/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.datasource.config;

import java.util.HashMap;
import java.util.List;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.september.smartdao.datasource.SmartDatasourceHolder;
import org.september.smartdao.datasource.SmartRoutingDataSource;
import org.september.smartdao.datasource.config.DataSourceGroup;
import org.september.smartdao.datasource.config.DataSourceProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConfigurationProperties(prefix="spring.alliance.dao")
public class SmartDaoDataSourceConfig {
    private List<DataSourceProperty> datasource;
    private String dialect;

    @Bean(name={"dataSource"}, initMethod="init")
    public SmartRoutingDataSource dataSource() {
        DataSourceGroup group;
        SmartRoutingDataSource rds = new SmartRoutingDataSource();
        if (this.dialect == null) {
            throw new RuntimeException("forgot to config a dialect by spring.alliance.dao.dialect ?");
        }
        rds.setDialect(this.dialect);
        if (this.datasource == null || this.datasource.isEmpty()) {
            throw new RuntimeException("forgot to config a datasource?");
        }
        rds.setDataSourcePropertys(this.datasource);
        HashMap<String, DataSource> dsMap = new HashMap<String, DataSource>();
        HashMap<String, DataSourceGroup> dsGroupsMap = new HashMap<String, DataSourceGroup>();
        for (DataSourceProperty dsp : this.datasource) {
            if (StringUtils.isEmpty((Object)dsp.getGroup())) {
                throw new RuntimeException("datasource.group can not be empty");
            }
            if (!dsGroupsMap.containsKey(dsp.getGroup())) {
                DataSourceGroup dsg = new DataSourceGroup();
                dsg.setName(dsp.getGroup());
                dsGroupsMap.put(dsg.getName(), dsg);
            }
            group = (DataSourceGroup)dsGroupsMap.get(dsp.getGroup());
            DataSource ds = new DataSource();
            ds.setUrl(dsp.getJdbcUrl());
            ds.setDriverClassName(dsp.getDriverClass());
            ds.setUsername(dsp.getUsername());
            ds.setPassword(dsp.getPassword());
            ds.setAbandonWhenPercentageFull(dsp.getAbandonWhenPercentageFull());
            ds.setAccessToUnderlyingConnectionAllowed(dsp.isAccessToUnderlyingConnectionAllowed());
            ds.setAlternateUsernameAllowed(dsp.isAlternateUsernameAllowed());
            ds.setCommitOnReturn(dsp.isCommitOnReturn());
            ds.setDataSourceJNDI(dsp.getDataSourceJNDI());
            ds.setDefaultAutoCommit(dsp.getDefaultAutoCommit());
            ds.setDefaultReadOnly(dsp.getDefaultReadOnly());
            ds.setDefaultTransactionIsolation(dsp.getDefaultTransactionIsolation());
            ds.setFairQueue(dsp.isFairQueue());
            ds.setIgnoreExceptionOnPreLoad(dsp.isIgnoreExceptionOnPreLoad());
            ds.setInitialSize(dsp.getInitialSize());
            ds.setInitSQL(dsp.getInitSQL());
            ds.setJdbcInterceptors(dsp.getJdbcInterceptors());
            ds.setJmxEnabled(dsp.isJmxEnabled());
            ds.setLogAbandoned(dsp.isLogAbandoned());
            ds.setLogValidationErrors(dsp.isLogValidationErrors());
            ds.setMaxActive(dsp.getMaxActive());
            ds.setMaxAge(dsp.getMaxAge());
            ds.setMaxIdle(dsp.getMaxIdle());
            ds.setMaxWait(dsp.getMaxWait());
            ds.setMinIdle(dsp.getMinIdle());
            ds.setMinEvictableIdleTimeMillis(dsp.getMinEvictableIdleTimeMillis());
            ds.setPropagateInterruptState(dsp.isPropagateInterruptState());
            ds.setRemoveAbandoned(dsp.isRemoveAbandoned());
            ds.setRemoveAbandonedTimeout(dsp.getRemoveAbandonedTimeout());
            ds.setRollbackOnReturn(dsp.isRollbackOnReturn());
            ds.setSuspectTimeout(dsp.getSuspectTimeout());
            ds.setTestOnBorrow(dsp.isTestOnBorrow());
            ds.setTestOnConnect(dsp.isTestOnConnect());
            ds.setTestOnReturn(dsp.isTestOnReturn());
            ds.setTestWhileIdle(dsp.isTestWhileIdle());
            ds.setTimeBetweenEvictionRunsMillis(dsp.getTimeBetweenEvictionRunsMillis());
            ds.setUseDisposableConnectionFacade(dsp.isUseDisposableConnectionFacade());
            ds.setUseEquals(dsp.isUseEquals());
            ds.setUseLock(dsp.isUseLock());
            ds.setUseStatementFacade(dsp.isUseStatementFacade());
            ds.setValidationQuery(dsp.getValidationQuery());
            ds.setValidationInterval(dsp.getValidationInterval());
            ds.setValidationQueryTimeout(dsp.getValidationQueryTimeout());
            if (dsp.getType() != null) {
                if (dsp.getType().contains("read")) {
                    group.getReadDSList().add(ds);
                }
                if (!dsp.getType().contains("write")) continue;
                group.setWriteDS(ds);
                continue;
            }
            throw new RuntimeException("datasource type can not be empty, must be read, write, or read/write.");
        }
        for (String key : dsGroupsMap.keySet()) {
            group = (DataSourceGroup)dsGroupsMap.get(key);
            if (group.getWriteDS() != null) {
                dsMap.put(String.valueOf(group.getName()) + "-write", group.getWriteDS());
            }
            int i = 0;
            while (i < group.getReadDSList().size()) {
                dsMap.put(String.valueOf(group.getName()) + "-read-" + i, group.getReadDSList().get(i));
                ++i;
            }
            SmartDatasourceHolder.getInstance().setDataSourceGroupMap(dsGroupsMap);
        }
        rds.setTargetDataSources(dsMap);
        return rds;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setDatasource(List<DataSourceProperty> datasource) {
        this.datasource = datasource;
    }
}

