/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.datasource;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.september.smartdao.datasource.config.DataSourceGroup;

public class SmartDatasourceHolder {
    private static Map<String, DataSourceGroup> dsGroupMap = new HashMap<String, DataSourceGroup>();
    private static ThreadLocal<String> currentDataSourceGroup = new ThreadLocal();
    private static ThreadLocal<Boolean> isReadonly = new ThreadLocal();
    private static SmartDatasourceHolder instance = new SmartDatasourceHolder();
    private static ThreadLocal<Boolean> datasourceLock = new ThreadLocal();
    private static Random rand = new Random();

    private SmartDatasourceHolder() {
    }

    public static String getDataSourceKey() {
        DataSourceGroup group;
        String key = currentDataSourceGroup.get();
        if (key == null) {
            group = dsGroupMap.values().iterator().next();
            SmartDatasourceHolder.setDataSourceGroup(group.getName());
        }
        key = currentDataSourceGroup.get();
        group = dsGroupMap.get(key);
        if (isReadonly.get() != null && isReadonly.get().booleanValue()) {
            int num = rand.nextInt(1000);
            return String.valueOf(group.getName()) + "-read-" + num % group.getReadDSList().size();
        }
        return String.valueOf(group.getName()) + "-write";
    }

    public static void switchToWrite() {
        if (datasourceLock.get() == null || !datasourceLock.get().booleanValue()) {
            isReadonly.set(false);
        }
    }

    public static void switchToRead() {
        if (datasourceLock.get() == null || !datasourceLock.get().booleanValue()) {
            isReadonly.set(true);
        }
    }

    public static void setDataSourceGroup(String group) {
        if (datasourceLock.get() == null || !datasourceLock.get().booleanValue()) {
            currentDataSourceGroup.set(group);
        }
    }

    public static SmartDatasourceHolder getInstance() {
        return instance;
    }

    public void setDataSourceGroupMap(Map<String, DataSourceGroup> map) {
        dsGroupMap = map;
    }

    public static void lockDataSource() {
        datasourceLock.set(true);
    }

    public static void releaseDataSourceLock() {
        datasourceLock.set(false);
    }
}

