/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.mybatis.spring.SqlSessionTemplate;
import org.september.core.exception.BusinessException;
import org.september.smartdao.anno.AutoIncrease;
import org.september.smartdao.anno.Sequence;
import org.september.smartdao.datasource.SmartDatasourceHolder;
import org.september.smartdao.model.Order;
import org.september.smartdao.model.Page;
import org.september.smartdao.model.ParamMap;
import org.september.smartdao.model.QueryPair;
import org.september.smartdao.util.ReflectHelper;
import org.september.smartdao.util.SqlHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonDao {
    @Autowired
    SqlSessionTemplate sqlSessionTemplate;

    public void save(Object entity) {
        try {
            SmartDatasourceHolder.switchToWrite();
            List<QueryPair> queryPairList = SqlHelper.getQueryPairs(entity);
            ParamMap pm = new ParamMap();
            pm.put("columnList", (Object)queryPairList);
            pm.put("tableName", (Object)SqlHelper.getTableName(entity.getClass()));
            String keyName = SqlHelper.getIdOfClass(entity.getClass()).getName();
            Sequence seq = SqlHelper.getIdOfClass(entity.getClass()).getAnnotation(Sequence.class);
            AutoIncrease auto = SqlHelper.getIdOfClass(entity.getClass()).getAnnotation(AutoIncrease.class);
            if (seq != null) {
                pm.put("selectKey", (Object)seq.selectKey());
                this.sqlSessionTemplate.insert("CommonEntityMapper.insertEntityWithSequence", (Object)pm);
                long id = (Long)pm.get("id");
                BeanUtils.setProperty((Object)entity, (String)keyName, (Object)id);
            } else if (auto != null) {
                this.sqlSessionTemplate.insert("CommonEntityMapper.insertEntityAutoIncrease", (Object)pm);
                long id = (Long)pm.get("id");
                BeanUtils.setProperty((Object)entity, (String)keyName, (Object)id);
            } else {
                this.sqlSessionTemplate.insert("CommonEntityMapper.insertEntityWithId", (Object)pm);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4fdd\u5b58\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public void update(Object entity) {
        try {
            SmartDatasourceHolder.switchToWrite();
            Field id = SqlHelper.getIdOfEntity(entity);
            id.setAccessible(true);
            if (id != null) {
                Object val = id.get(entity);
                if (val == null) {
                    throw new BusinessException("id can't be null when update");
                }
                this.updateByField(entity.getClass(), id.getName(), val, entity, false);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public void updateWithNullFields(Object entity) {
        try {
            SmartDatasourceHolder.switchToWrite();
            Field id = SqlHelper.getIdOfEntity(entity);
            id.setAccessible(true);
            if (id != null) {
                Object val = id.get(entity);
                if (val == null) {
                    throw new RuntimeException("id can't be null when update");
                }
                this.updateByField(entity.getClass(), id.getName(), val, entity, true);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public int deleteByIds(Class<?> clazz, List<Object> ids) {
        SmartDatasourceHolder.switchToWrite();
        ParamMap pm = new ParamMap();
        pm.put("idColumn", (Object)SqlHelper.getIdColumnOfClass(clazz));
        pm.put("tableName", (Object)SqlHelper.getTableName(clazz));
        pm.put("ids", (Object)ids);
        return this.sqlSessionTemplate.delete("CommonEntityMapper.deleteByIds", (Object)pm);
    }

    public void delete(Object entity) {
        Object val;
        SmartDatasourceHolder.switchToWrite();
        ParamMap pm = new ParamMap();
        Field id = SqlHelper.getIdOfEntity(entity);
        if (id != null) {
            val = null;
            try {
                id.setAccessible(true);
                val = id.get(entity);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (val == null) {
                throw new RuntimeException("id can't be null when delete");
            }
        } else {
            throw new RuntimeException("id field not found for class " + entity.getClass());
        }
        pm.put("idColumn", (Object)SqlHelper.getIdColumnOfEntity(entity));
        pm.put("idValue", val);
        pm.put("tableName", (Object)SqlHelper.getTableName(entity.getClass()));
        this.sqlSessionTemplate.delete("CommonEntityMapper.deleteById", (Object)pm);
    }

    public <T> T get(Class<T> clazz, Object id) {
        if (id == null) {
            return null;
        }
        SmartDatasourceHolder.switchToRead();
        String tableName = SqlHelper.getTableName(clazz);
        ParamMap pm = new ParamMap();
        pm.put("tableName", (Object)tableName);
        pm.put("idColumn", (Object)SqlHelper.getIdColumnOfClass(clazz));
        pm.put("idValue", id);
        Map map = (Map)this.sqlSessionTemplate.selectOne("CommonEntityMapper.getById", (Object)pm);
        T result = ReflectHelper.transformMapToEntity(clazz, map);
        return result;
    }

    public <T> T getByExample(T example) {
        if (example == null) {
            return null;
        }
        List<T> list = this.listByExample(example);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public <T> List<T> listByExample(T example) {
        return this.listByExample(example, null);
    }

    public <T> List<T> listByExample(T vo, List<Order> orders) {
        SmartDatasourceHolder.switchToRead();
        String tableName = SqlHelper.getTableName(vo.getClass());
        List<QueryPair> queryPairs = SqlHelper.getQueryPairs(vo);
        ParamMap pm = new ParamMap();
        pm.put("tableName", (Object)tableName);
        pm.put("queryPairList", (Object)queryPairs);
        if (orders != null && !orders.isEmpty()) {
            pm.put("orders", (Object)orders);
        }
        List mapResult = this.sqlSessionTemplate.selectList("CommonEntityMapper.listByExample", (Object)pm);
        List<?> entityResult = ReflectHelper.transformMapToEntity(vo.getClass(), mapResult);
        return entityResult;
    }

    public List<Map<String, Object>> listByParams(String statementId, ParamMap pm) {
        SmartDatasourceHolder.switchToRead();
        List result = this.sqlSessionTemplate.selectList(statementId, (Object)pm);
        return result;
    }

    public Map<String, Object> findOne(String statement, ParamMap paramMap) {
        List<Map<String, Object>> list = this.listByParams(statement, paramMap);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public <T> List<T> listByParams(Class<T> clazz, String statementId, ParamMap paramMap) {
        List<Map<String, Object>> mapResult = this.listByParams(statementId, paramMap);
        List<Object> entityResult = null;
        entityResult = mapResult.isEmpty() ? new ArrayList() : ReflectHelper.transformMapToEntity(clazz, mapResult);
        return entityResult;
    }

    public <T> Page<T> findPageByExample(Class<T> clazz, Page<T> page, Object example) {
        SmartDatasourceHolder.switchToRead();
        String tableName = SqlHelper.getTableName(clazz);
        List<QueryPair> queryPairs = SqlHelper.getQueryPairs(example);
        ParamMap paramMap = new ParamMap();
        paramMap.put("tableName", (Object)tableName);
        paramMap.put("queryPairList", (Object)queryPairs);
        paramMap.put("page", (Object)page);
        com.github.pagehelper.Page innerPage = PageHelper.startPage((int)page.getCurrentPage(), (int)page.getPageSize());
        List mapResult = this.sqlSessionTemplate.selectList("CommonEntityMapper.findPage", (Object)paramMap);
        List<T> entityResult = ReflectHelper.transformMapToEntity(clazz, mapResult);
        page.setResult(entityResult);
        PageInfo pageInfo = innerPage.toPageInfo();
        page.setTotalResult((int)pageInfo.getTotal());
        page.setStartRow(pageInfo.getStartRow());
        page.setEndRow(pageInfo.getEndRow());
        return page;
    }

    public <T> Page<T> findPageByParams(Class<T> clazz, Page<T> page, String statement, ParamMap paramMap) {
        if (page == null) {
            throw new RuntimeException("page can not be null when findPageByParams");
        }
        com.github.pagehelper.Page innerPage = PageHelper.startPage((int)page.getCurrentPage(), (int)page.getPageSize());
        List<T> resultLists = this.listByParams(clazz, statement, paramMap);
        PageInfo pageInfo = innerPage.toPageInfo();
        page.setResult(resultLists);
        page.setTotalResult((int)pageInfo.getTotal());
        page.setStartRow(pageInfo.getStartRow());
        page.setEndRow(pageInfo.getEndRow());
        return page;
    }

    public Page<Map<String, Object>> findPageByParams(Page<Map<String, Object>> page, String statement, ParamMap paramMap) {
        if (page == null) {
            throw new RuntimeException("page can not be null when findPageByParams");
        }
        com.github.pagehelper.Page innerPage = PageHelper.startPage((int)page.getCurrentPage(), (int)page.getPageSize());
        List<Map<String, Object>> resultsMap = this.listByParams(statement, paramMap);
        PageInfo pageInfo = innerPage.toPageInfo();
        page.setResult(resultsMap);
        page.setTotalResult((int)pageInfo.getTotal());
        page.setStartRow(pageInfo.getStartRow());
        page.setEndRow(pageInfo.getEndRow());
        return page;
    }

    public int execute(String statement, ParamMap paramMap) {
        SmartDatasourceHolder.switchToWrite();
        return this.sqlSessionTemplate.update(statement, (Object)paramMap);
    }

    public <T> int updateByField(Class<T> clazz, String fieldName, Object fieldValue, Object updateObj, boolean updateNull) {
        String tableName = SqlHelper.getTableName(clazz);
        Field[] fields = SqlHelper.getFieldsWithoutTransient(clazz);
        ArrayList columns = new ArrayList();
        String whereColumnName = fieldName;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Field f = fieldArray[n2];
                if (f.getName().equals(fieldName)) {
                    whereColumnName = SqlHelper.getColumnName(f);
                } else {
                    HashMap<String, Object> column = new HashMap<String, Object>();
                    String columnName = SqlHelper.getColumnName(f);
                    column.put("name", columnName);
                    f.setAccessible(true);
                    try {
                        Object value = f.get(updateObj);
                        if (value == null && !updateNull) break block7;
                        if (f.getType().isEnum() && value != null) {
                            column.put("value", ((Enum)value).ordinal());
                        } else {
                            column.put("value", value);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    columns.add(column);
                }
            }
            ++n2;
        }
        ParamMap pm = new ParamMap();
        pm.put("tableName", (Object)tableName);
        pm.put("fieldName", (Object)whereColumnName);
        pm.put("fieldValue", fieldValue);
        pm.put("columnList", (Object)columns);
        int result = this.execute("CommonEntityMapper.updateByField", pm);
        return result;
    }

    public <T> int batchInsert(Class<T> clazz, List<T> list) throws IllegalArgumentException, IllegalAccessException {
        SmartDatasourceHolder.switchToWrite();
        ParamMap pm = new ParamMap();
        Field[] fields = SqlHelper.getFieldsWithoutTransient(clazz);
        ArrayList<String> columns = new ArrayList<String>();
        int i = 0;
        while (i < fields.length) {
            if (!SqlHelper.isAutoInstreaseField(fields[i])) {
                columns.add(SqlHelper.getColumnName(fields[i]));
            }
            ++i;
        }
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        for (T obj : list) {
            List<Object> values = this.getColumnValues(obj);
            rows.add(values);
        }
        pm.put("tableName", (Object)SqlHelper.getTableName(clazz));
        pm.put("columns", (Object)columns);
        pm.put("rows", (Object)rows);
        if (SqlHelper.isAutoInstreaseField(SqlHelper.getIdOfClass(clazz))) {
            return this.execute("CommonEntityMapper.batchInsertAutoIncrease", pm);
        }
        Sequence seq = SqlHelper.getIdOfClass(clazz).getAnnotation(Sequence.class);
        pm.put("selectKey", (Object)seq.selectKey());
        return this.execute("CommonEntityMapper.batchInsertBySequence", pm);
    }

    private List<Object> getColumnValues(Object obj) {
        ArrayList<Object> values = new ArrayList<Object>();
        Field[] fields = SqlHelper.getFieldsWithoutTransient(obj.getClass());
        int i = 0;
        while (i < fields.length) {
            if (!SqlHelper.isAutoInstreaseField(fields[i])) {
                Field idField;
                Sequence seqAno;
                if (SqlHelper.isIdField(fields[i]) && (seqAno = (idField = fields[i]).getAnnotation(Sequence.class)) != null) {
                    String selectKey = seqAno.selectKey();
                    ParamMap pm = new ParamMap();
                    pm.put("selectKey", (Object)selectKey);
                    Long id = (Long)this.sqlSessionTemplate.selectOne("CommonEntityMapper.selectId", (Object)pm);
                    values.add(id);
                } else {
                    try {
                        fields[i].setAccessible(true);
                        Object val = fields[i].get(obj);
                        values.add(val);
                    }
                    catch (Exception e) {
                        throw new BusinessException("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
                    }
                }
            }
            ++i;
        }
        return values;
    }

    public int countByExample(Object vo) {
        SmartDatasourceHolder.switchToRead();
        String tableName = SqlHelper.getTableName(vo.getClass());
        Field[] fields = SqlHelper.getFieldsWithoutTransient(vo.getClass());
        ArrayList columns = new ArrayList();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Field f = fieldArray[n2];
                HashMap<String, Object> column = new HashMap<String, Object>();
                String columnName = SqlHelper.getColumnName(f);
                column.put("name", columnName);
                f.setAccessible(true);
                try {
                    Object value = f.get(vo);
                    if (value == null) break block5;
                    if (f.getType().isEnum() && value != null) {
                        column.put("value", ((Enum)value).ordinal());
                    } else {
                        column.put("value", value);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                columns.add(column);
            }
            ++n2;
        }
        ParamMap pm = new ParamMap();
        pm.put("tableName", (Object)tableName);
        pm.put("columnList", (Object)columns);
        Long result = (Long)this.sqlSessionTemplate.selectOne("CommonEntityMapper.countByExample", (Object)pm);
        return result.intValue();
    }
}

