/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.mybatisPlugs;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import org.september.smartdao.model.ParamMap;
import org.springframework.util.StringUtils;

public class SmartMySqlOutputVisitor
extends MySqlOutputVisitor {
    private ParamMap pm;

    public SmartMySqlOutputVisitor(Appendable appender, ParamMap pm) {
        super(appender);
        this.pm = pm;
    }

    public boolean checkNode(SQLExpr x) {
        if (x instanceof SQLBinaryOpExpr) {
            return SmartMySqlOutputVisitor.checkRight((SQLBinaryOpExpr)x, this.pm);
        }
        if (x instanceof SQLInListExpr) {
            return SmartMySqlOutputVisitor.checkRight((SQLInListExpr)x, this.pm);
        }
        if (x instanceof SQLVariantRefExpr) {
            return SmartMySqlOutputVisitor.checkRight((SQLVariantRefExpr)x, this.pm);
        }
        if (x instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr methodExpr = (SQLMethodInvokeExpr)x;
            return SmartMySqlOutputVisitor.checkRight(methodExpr, this.pm);
        }
        return true;
    }

    public boolean visit(SQLBinaryOpExpr x) {
        boolean relational;
        SQLObject parent = x.getParent();
        boolean isRoot = parent instanceof SQLSelectQueryBlock;
        boolean bl = relational = x.getOperator() == SQLBinaryOperator.BooleanAnd || x.getOperator() == SQLBinaryOperator.BooleanOr;
        if (this.isLeaf(x.getLeft()) && !this.checkNode(x.getRight())) {
            return false;
        }
        if (isRoot && relational) {
            this.incrementIndent();
        }
        ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>();
        SQLExpr left = x.getLeft();
        while (left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)left).getOperator() == x.getOperator()) {
            SQLBinaryOpExpr binaryLeft = (SQLBinaryOpExpr)left;
            groupList.add(binaryLeft.getRight());
            left = binaryLeft.getLeft();
        }
        groupList.add(left);
        Appendable xx = this.appender;
        for (int i = groupList.size() - 1; i >= 0; --i) {
            SQLExpr item = (SQLExpr)groupList.get(i);
            if (!this.isNotEmpty(item)) continue;
            this.visitBinaryLeft(item, x.getOperator());
            String sql = this.appender.toString().trim();
            if (sql.endsWith(SQLBinaryOperator.BooleanAnd.name) || sql.endsWith(SQLBinaryOperator.BooleanOr.name) || "".equals(sql)) continue;
            if (relational) {
                this.println();
                this.print(" ");
            } else {
                this.print(" ");
            }
            this.print(x.getOperator().name);
            this.print(" ");
        }
        this.visitorBinaryRight(x);
        if (isRoot && relational) {
            this.decrementIndent();
        }
        return false;
    }

    private boolean isNotEmpty(SQLExpr left) {
        StringBuilder out = new StringBuilder();
        SmartMySqlOutputVisitor tmpVisitor = new SmartMySqlOutputVisitor(out, this.pm);
        left.accept((SQLASTVisitor)tmpVisitor);
        return !StringUtils.isEmpty((Object)out.toString().trim()) && !"()".equals(out.toString().trim());
    }

    public boolean visit(MySqlSelectQueryBlock x) {
        if (x.getOrderBy() != null) {
            x.getOrderBy().setParent((SQLObject)x);
        }
        this.print("SELECT ");
        int size = x.getHintsSize();
        for (int i = 0; i < size; ++i) {
            SQLCommentHint hint = (SQLCommentHint)x.getHints().get(i);
            hint.accept((SQLASTVisitor)this);
            this.print(' ');
        }
        if (1 == x.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == x.getDistionOption()) {
            this.print("DISTINCT ");
        } else if (4 == x.getDistionOption()) {
            this.print("DISTINCTROW ");
        }
        if (x.isHignPriority()) {
            this.print("HIGH_PRIORITY ");
        }
        if (x.isStraightJoin()) {
            this.print("STRAIGHT_JOIN ");
        }
        if (x.isSmallResult()) {
            this.print("SQL_SMALL_RESULT ");
        }
        if (x.isBigResult()) {
            this.print("SQL_BIG_RESULT ");
        }
        if (x.isBufferResult()) {
            this.print("SQL_BUFFER_RESULT ");
        }
        if (x.getCache() != null) {
            if (x.getCache().booleanValue()) {
                this.print("SQL_CACHE ");
            } else {
                this.print("SQL_NO_CACHE ");
            }
        }
        if (x.isCalcFoundRows()) {
            this.print("SQL_CALC_FOUND_ROWS ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            this.print("INTO ");
            x.getInto().accept((SQLASTVisitor)this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print("FROM ");
            x.getFrom().accept((SQLASTVisitor)this);
        }
        if (x.getWhere() != null) {
            x.getWhere().setParent((SQLObject)x);
            StringBuilder out = new StringBuilder();
            SmartMySqlOutputVisitor tmpVisitor = new SmartMySqlOutputVisitor(out, this.pm);
            x.getWhere().accept((SQLASTVisitor)tmpVisitor);
            if (!StringUtils.isEmpty((Object)out.toString().trim())) {
                this.println();
                this.print("WHERE ");
                this.print(out.toString());
            }
        }
        if (x.getGroupBy() != null) {
            this.trimEndOper();
            this.println();
            x.getGroupBy().accept((SQLASTVisitor)this);
        }
        if (x.getOrderBy() != null) {
            this.trimEndOper();
            this.println();
            x.getOrderBy().accept((SQLASTVisitor)this);
        }
        if (x.getLimit() != null) {
            this.trimEndOper();
            this.println();
            x.getLimit().accept((SQLASTVisitor)this);
        }
        if (x.getProcedureName() != null) {
            this.print(" PROCEDURE ");
            x.getProcedureName().accept((SQLASTVisitor)this);
            if (x.getProcedureArgumentList().size() > 0) {
                this.print("(");
                this.printAndAccept(x.getProcedureArgumentList(), ", ");
                this.print(")");
            }
        }
        if (x.isForUpdate()) {
            this.println();
            this.print("FOR UPDATE");
        }
        if (x.isLockInShareMode()) {
            this.println();
            this.print("LOCK IN SHARE MODE");
        }
        return false;
    }

    public boolean visit(SQLInListExpr x) {
        if (!this.checkNode((SQLExpr)x)) {
            return false;
        }
        return super.visit(x);
    }

    private static boolean checkRight(SQLBinaryOpExpr node, ParamMap pm) {
        if (node.getRight() instanceof SQLVariantRefExpr) {
            return SmartMySqlOutputVisitor.checkRight((SQLVariantRefExpr)node.getRight(), pm);
        }
        if (node.getRight() instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr methodExpr = (SQLMethodInvokeExpr)node.getRight();
            return SmartMySqlOutputVisitor.checkRight(methodExpr, pm);
        }
        return true;
    }

    private static boolean checkRight(SQLMethodInvokeExpr methodExpr, ParamMap pm) {
        for (SQLExpr expr : methodExpr.getParameters()) {
            if (!(expr instanceof SQLVariantRefExpr)) continue;
            SQLVariantRefExpr refExpr = (SQLVariantRefExpr)expr;
            if (!pm.containsKey(refExpr.getName())) {
                return false;
            }
            Object val = pm.get(refExpr.getName());
            if (!StringUtils.isEmpty((Object)val)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkRight(SQLInListExpr inExpr, ParamMap pm) {
        for (SQLExpr expr : inExpr.getTargetList()) {
            if (!(expr instanceof SQLVariantRefExpr)) continue;
            SQLVariantRefExpr refExpr = (SQLVariantRefExpr)expr;
            if (!pm.containsKey(refExpr.getName())) {
                return false;
            }
            Object val = pm.get(refExpr.getName());
            if (!StringUtils.isEmpty((Object)val)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkRight(SQLVariantRefExpr refExpr, ParamMap pm) {
        if (!pm.containsKey(refExpr.getName())) {
            return false;
        }
        Object val = pm.get(refExpr.getName());
        return !StringUtils.isEmpty((Object)val);
    }

    private void visitBinaryLeft(SQLExpr left, SQLBinaryOperator op) {
        if (left instanceof SQLBinaryOpExpr) {
            boolean leftRational;
            SQLBinaryOpExpr binaryLeft = (SQLBinaryOpExpr)left;
            boolean bl = leftRational = binaryLeft.getOperator() == SQLBinaryOperator.BooleanAnd || binaryLeft.getOperator() == SQLBinaryOperator.BooleanOr;
            if (binaryLeft.getOperator().priority > op.priority) {
                if (leftRational) {
                    this.incrementIndent();
                    this.println();
                }
                this.print('(');
                left.accept((SQLASTVisitor)this);
                this.print(')');
                if (leftRational) {
                    this.decrementIndent();
                }
            } else {
                left.accept((SQLASTVisitor)this);
            }
        } else {
            left.accept((SQLASTVisitor)this);
        }
    }

    private void visitorBinaryRight(SQLBinaryOpExpr x) {
        if (!this.checkNode(x.getRight())) {
            return;
        }
        if (x.getRight() instanceof SQLBinaryOpExpr) {
            boolean rightRational;
            SQLBinaryOpExpr right = (SQLBinaryOpExpr)x.getRight();
            boolean bl = rightRational = right.getOperator() == SQLBinaryOperator.BooleanAnd || right.getOperator() == SQLBinaryOperator.BooleanOr;
            if (right.getOperator().priority >= x.getOperator().priority) {
                if (rightRational) {
                    this.incrementIndent();
                }
                this.print('(');
                right.accept((SQLASTVisitor)this);
                this.print(')');
                if (rightRational) {
                    this.decrementIndent();
                }
            } else {
                right.accept((SQLASTVisitor)this);
            }
        } else {
            x.getRight().accept((SQLASTVisitor)this);
        }
    }

    private boolean isLeaf(SQLExpr expr) {
        if (expr instanceof SQLPropertyExpr) {
            return true;
        }
        return expr instanceof SQLIdentifierExpr;
    }

    private void trimEndOper() {
        StringBuilder sb = (StringBuilder)this.appender;
        String sql = sb.toString().trim();
        if ((sql = sql.replace("()", "").trim()).endsWith(SQLBinaryOperator.BooleanAnd.name)) {
            sql = sql.substring(0, sql.length() - 3);
        } else if (sql.endsWith(SQLBinaryOperator.BooleanOr.name)) {
            sql = sql.substring(0, sql.length() - 2);
        } else if (sql.endsWith("WHERE")) {
            sql = sql.substring(0, sql.length() - 5);
        }
        sb.delete(0, sb.length());
        sb.append(sql);
    }
}

