/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class Order {
    private Direction direction;
    private String property;
    private static String INJECTION_REGEX = "[A-Za-z0-9\\_\\-\\+\\.]+";

    public Order(String property, Direction direction) {
        this.direction = direction;
        this.property = property;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String getProperty() {
        return this.property;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public static boolean isSQLInjection(String str) {
        return !Pattern.matches(INJECTION_REGEX, str);
    }

    public String toString() {
        if (Order.isSQLInjection(this.property)) {
            throw new IllegalArgumentException("SQLInjection property: " + this.property);
        }
        return this.property + (this.direction == null ? "" : " " + this.direction.name());
    }

    public static List<Order> formString(String orderSegment) {
        return Order.formString(orderSegment, null);
    }

    public static List<Order> formString(String orderSegment, String orderExpr) {
        if (orderSegment == null || orderSegment.trim().equals("")) {
            return new ArrayList<Order>(0);
        }
        ArrayList<Order> results = new ArrayList<Order>();
        String[] orderSegments = orderSegment.trim().split(",");
        for (int i = 0; i < orderSegments.length; ++i) {
            String sortSegment = orderSegments[i];
            Order order = Order._formString(sortSegment, orderExpr);
            if (order == null) continue;
            results.add(order);
        }
        return results;
    }

    private static Order _formString(String orderSegment, String orderExpr) {
        if (orderSegment == null || orderSegment.trim().equals("") || orderSegment.startsWith("null.") || orderSegment.startsWith(".")) {
            return null;
        }
        String[] array = orderSegment.trim().split("\\.");
        if (array.length != 1 && array.length != 2) {
            throw new IllegalArgumentException("orderSegment pattern must be {property}.{direction}, input is: " + orderSegment);
        }
        return Order.create(array[0], array.length == 2 ? array[1] : "asc", orderExpr);
    }

    public static Order create(String property, String direction) {
        return Order.create(property, direction, null);
    }

    public static Order create(String property, String direction, String orderExpr) {
        return new Order(property, Direction.fromString(direction));
    }

    public static enum Direction {
        ASC,
        DESC;


        public static Direction fromString(String value) {
            try {
                return Direction.valueOf(value.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                return ASC;
            }
        }
    }
}

