/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.datasource.config;

import java.util.HashMap;
import java.util.List;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.september.smartdao.datasource.SmartDatasourceHolder;
import org.september.smartdao.datasource.SmartRoutingDataSource;
import org.september.smartdao.datasource.config.DataSourceGroup;
import org.september.smartdao.datasource.config.DataSourceProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConfigurationProperties(prefix="spring.alliance.dao")
public class SmartDaoDataSourceConfig {
    private List<DataSourceProperty> datasource;

    @Bean(name={"dataSource"}, initMethod="init")
    public SmartRoutingDataSource dataSource() {
        DataSourceGroup group;
        SmartRoutingDataSource rds = new SmartRoutingDataSource();
        rds.setDataSourcePropertys(this.datasource);
        HashMap<String, DataSource> dsMap = new HashMap<String, DataSource>();
        HashMap<String, DataSourceGroup> dsGroupsMap = new HashMap<String, DataSourceGroup>();
        for (DataSourceProperty dsp : this.datasource) {
            if (StringUtils.isEmpty((Object)dsp.getGroup())) {
                throw new RuntimeException("datasource.group can not be empty");
            }
            if (!dsGroupsMap.containsKey(dsp.getGroup())) {
                DataSourceGroup dsg = new DataSourceGroup();
                dsg.setName(dsp.getGroup());
                dsGroupsMap.put(dsg.getName(), dsg);
            }
            group = (DataSourceGroup)dsGroupsMap.get(dsp.getGroup());
            DataSource ds = new DataSource();
            ds.setUrl(dsp.getJdbcUrl());
            ds.setDriverClassName(dsp.getDriverClass());
            ds.setUsername(dsp.getUsername());
            ds.setPassword(dsp.getPassword());
            ds.setMaxActive(dsp.getMaxActive());
            ds.setInitialSize(dsp.getInitialSize());
            ds.setTestWhileIdle(false);
            if (dsp.getType() != null) {
                if (dsp.getType().contains("read")) {
                    group.getReadDSList().add(ds);
                }
                if (!dsp.getType().contains("write")) continue;
                group.setWriteDS(ds);
                continue;
            }
            throw new RuntimeException("datasource type can not be empty, must be read, write, or read/write.");
        }
        for (String key : dsGroupsMap.keySet()) {
            group = (DataSourceGroup)dsGroupsMap.get(key);
            if (group.getWriteDS() != null) {
                dsMap.put(group.getName() + "-write", group.getWriteDS());
            }
            for (int i = 0; i < group.getReadDSList().size(); ++i) {
                dsMap.put(group.getName() + "-read-" + i, group.getReadDSList().get(i));
            }
            SmartDatasourceHolder.getInstance().setDataSourceGroupMap(dsGroupsMap);
        }
        rds.setTargetDataSources(dsMap);
        return rds;
    }

    public void setDatasource(List<DataSourceProperty> datasource) {
        this.datasource = datasource;
    }
}

