/*
 * Decompiled with CFR 0.152.
 */
package org.september.simpleweb.support;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.september.core.exception.BusinessException;
import org.springframework.util.StringUtils;

public class FormattedDateEditor
extends PropertyEditorSupport {
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        Date date = null;
        SimpleDateFormat sdf = null;
        try {
            if (Pattern.compile("([GMT]|[gmt])").matcher(text).find()) {
                sdf = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss z", Locale.ENGLISH);
                try {
                    text = text.replace("GMT", "").replaceAll("\\(.*\\)", "");
                    date = sdf.parse(text);
                    this.setValue(date);
                    return;
                }
                catch (ParseException e) {
                    throw new BusinessException("\u65f6\u95f4\u683c\u5f0f\u89e3\u6790\u9519\u8bef", (Throwable)e);
                }
            }
            if (!StringUtils.isEmpty((Object)text)) {
                sdf = this.getSimpleDateFormat(text);
                date = sdf.parse(text);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.setValue(date);
    }

    private SimpleDateFormat getSimpleDateFormat(String source) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (Pattern.matches("^\\d{4}-\\d{2}-\\d{2}$", source)) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
        } else if (Pattern.matches("^\\d{4}-\\d{2}-\\d{2} \\d{2}-\\d{2}-\\d{2}$", source)) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        } else if (Pattern.matches("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$", source)) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        } else if (Pattern.matches("^\\d{4}/\\d{2}/\\d{2}$", source)) {
            sdf = new SimpleDateFormat("yyyy/MM/dd");
        } else if (Pattern.matches("^\\d{4}/\\d{2}/\\d{2} \\d{2}/\\d{2}/\\d{2}$", source)) {
            sdf = new SimpleDateFormat("yyyy/MM/dd HH/mm/ss");
        } else if (Pattern.matches("^\\d{4}\\d{2}\\d{2}$", source)) {
            sdf = new SimpleDateFormat("yyyyMMdd");
        } else if (Pattern.matches("^\\d{4}\\d{2}\\d{2} \\d{2}\\d{2}\\d{2}$", source)) {
            sdf = new SimpleDateFormat("yyyyMMdd HHmmss");
        } else if (Pattern.matches("^\\d{4}\\.\\d{2}\\.\\d{2}$", source)) {
            sdf = new SimpleDateFormat("yyyy.MM.dd");
        } else if (Pattern.matches("^\\d{4}\\.\\d{2}\\.\\d{2} \\d{2}\\.\\d{2}\\.\\d{2}$", source)) {
            sdf = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss");
        } else if (Pattern.matches("^\\d{4}-\\d{2}$", source)) {
            sdf = new SimpleDateFormat("yyyy-MM");
        } else {
            throw new BusinessException("\u65e0\u6cd5\u8bc6\u522b\u7684\u65f6\u95f4\u683c\u5f0f");
        }
        return sdf;
    }
}

