/*
 * Decompiled with CFR 0.152.
 */
package org.september.simpleweb.exception;

import com.alibaba.fastjson.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ValidationException;
import java.io.IOException;
import org.september.core.component.log.LogHelper;
import org.september.core.exception.BusinessException;
import org.september.core.exception.NotAuthorizedException;
import org.september.simpleweb.model.ArgError;
import org.september.simpleweb.model.ResponseVo;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.resource.NoResourceFoundException;

@ControllerAdvice
public class DefaultExceptionHandler {
    protected static final LogHelper logger = LogHelper.getLogger(DefaultExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public ResponseVo<String> handleBindException(BindException e) {
        logger.getBuilder().warn("\u53c2\u6570\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        ResponseVo<String> resp = ResponseVo.BUILDER().setCode(-1).setErrorType("args_not_valid");
        resp.setDesc("\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        BindingResult result = e.getBindingResult();
        for (FieldError error : result.getFieldErrors()) {
            ArgError err = new ArgError();
            err.setField(error.getField());
            err.setMessage(error.getDefaultMessage());
            resp.getArgErrors().add(err);
        }
        return resp;
    }

    @ResponseBody
    @ExceptionHandler(value={ValidationException.class})
    public ResponseVo<String> handleValidationException(ValidationException e) {
        logger.getBuilder().warn("\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef", (Throwable)e);
        return ResponseVo.BUILDER().setCode(-1).setErrorType("biz_exception").setDesc("\u53c2\u6570\u9a8c\u8bc1\u5f02\u5e38");
    }

    @ExceptionHandler(value={NoResourceFoundException.class})
    public Object handleNoResourceFoundException(NoResourceFoundException e) {
        return "/404";
    }

    @ExceptionHandler(value={Exception.class})
    public Object defaultErrorHandler(Exception e, HttpServletRequest request, HttpServletResponse response) {
        HandlerMethod handlerMethod = null;
        logger.getBuilder().warn("\u4e1a\u52a1\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
        if (request.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE) instanceof HandlerMethod) {
            handlerMethod = (HandlerMethod)request.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
        }
        boolean isXhr = false;
        if (handlerMethod != null) {
            RestController restAnno = handlerMethod.getBeanType().getAnnotation(RestController.class);
            ResponseBody anno = (ResponseBody)handlerMethod.getMethodAnnotation(ResponseBody.class);
            if (restAnno != null || anno != null) {
                isXhr = true;
            }
        }
        if (isXhr) {
            if (e instanceof BusinessException) {
                respVo = ResponseVo.BUILDER().setCode(-1).setErrorType("biz_exception").setDesc(e.getMessage());
                DefaultExceptionHandler.responseAjax(response, respVo);
            } else {
                respVo = ResponseVo.BUILDER().setCode(-1).setErrorType("unexpect_exception").setDesc(e.getMessage());
                DefaultExceptionHandler.responseAjax(response, respVo);
            }
            return null;
        }
        ModelAndView modelAndView = new ModelAndView();
        if (e instanceof NoResourceFoundException) {
            modelAndView.setViewName("404");
        } else if (e instanceof NotAuthorizedException) {
            modelAndView.setViewName("503");
        } else {
            modelAndView.setViewName("500");
        }
        modelAndView.addObject("desc", (Object)e.getMessage());
        return modelAndView;
    }

    public static void responseAjax(HttpServletResponse response, Object responseVo) {
        try {
            try {
                String result = JSON.toJSONString((Object)responseVo);
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                response.getOutputStream().write(result.getBytes("UTF-8"));
                response.getOutputStream().flush();
            }
            catch (IOException e) {
                logger.getBuilder().error("Ajax\u8fd4\u56de\u503c\u5f02\u5e38", (Throwable)e);
                try {
                    response.getOutputStream().close();
                }
                catch (IOException e2) {
                    logger.getBuilder().error("\u5199\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.getBuilder().error("\u5199\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

