/*
 * Decompiled with CFR 0.152.
 */
package org.september.simpleweb.controller;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.september.core.component.ApplicationContextHolder;
import org.september.simpleweb.auth.PublicMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/_easyconf"})
public class ConfigCenterRefreshController {
    @Autowired
    private AbstractEnvironment environment;

    @PublicMethod
    @ResponseBody
    @RequestMapping(value={"/refresh"})
    public String refresh() {
        PropertySource target = null;
        String configLocation = this.environment.getProperty("spring.config.location");
        if (!StringUtils.isEmpty((Object)configLocation)) {
            for (PropertySource ps : this.environment.getPropertySources()) {
                if (!ps.getName().startsWith("applicationConfig") || !StringUtils.startsWithIgnoreCase((String)configLocation, (String)"http")) continue;
                target = ps;
                break;
            }
        }
        if (target == null) {
            return "--spring.config.location\u6ca1\u6709\u914d\u7f6e\uff0c\u6216\u8005\u4e0d\u662f\u4e00\u4e2aurl\u5730\u5740\uff0c\u4f60\u53ef\u80fd\u6ca1\u6709\u4f7f\u7528\u914d\u7f6e\u4e2d\u5fc3\uff0c\u6ca1\u6709\u914d\u7f6e\u53ef\u4ee5\u5237\u65b0";
        }
        Properties pros = new Properties();
        try {
            PropertiesLoaderUtils.fillProperties((Properties)pros, (Resource)new UrlResource(configLocation));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "reload failed , " + e.getMessage();
        }
        Map map = (Map)target.getSource();
        map.clear();
        map.putAll(pros);
        String[] stringArray = ApplicationContextHolder.getContext().getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Object bean = ApplicationContextHolder.getContext().getBean(beanName);
            Field[] fieldArray = bean.getClass().getDeclaredFields();
            int n3 = fieldArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String key;
                Field f = fieldArray[n4];
                Value valueAnno = f.getAnnotation(Value.class);
                if (valueAnno != null && (key = valueAnno.value()) != null) {
                    key = key.replace("${", "").replace("}", "");
                    if (map.containsKey(key = key.split(":")[0])) {
                        f.setAccessible(true);
                        try {
                            f.set(bean, map.get(key));
                        }
                        catch (Exception e) {
                            return e.getMessage();
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return "all @Value field update success";
    }
}

