/*
 * Decompiled with CFR 0.152.
 */
package org.september.simpleweb.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class IpUtils {
    private static String Ip_Unknown = "unknown";

    public static String getIp(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String ip = request.getHeader("x-forwarded-for");
        if (!(IpUtils.validateIp(ip) || IpUtils.validateIp(ip = request.getHeader("Proxy-Client-IP")) || IpUtils.validateIp(ip = request.getHeader("WL-Proxy-Client-IP")))) {
            ip = request.getRemoteAddr();
        }
        return IpUtils.conver(ip);
    }

    private static boolean validateIp(String ip) {
        return ip != null && ip.length() != 0 && !Ip_Unknown.equalsIgnoreCase(ip);
    }

    private static String conver(String ip) {
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            return "127.0.0.1";
        }
        return ip;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || Ip_Unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        } else {
            String[] ipArray = ip.split("\\,");
            ip = ipArray[0];
        }
        if (ip == null || ip.length() == 0 || Ip_Unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || Ip_Unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("clientip");
        }
        if (ip == null || ip.length() == 0 || Ip_Unknown.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return IpUtils.conver(ip);
    }

    public static InetAddress getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                if (addr.isLoopbackAddress() || addr.isLinkLocalAddress()) continue;
                return addr;
            }
        }
        throw new SocketException("Can't get our ip address, interfaces are: " + interfaces);
    }

    public static boolean isIP(String addr) {
        if (addr.length() < 7 || addr.length() > 15 || "".equals(addr)) {
            return false;
        }
        String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(addr);
        boolean ipAddress = mat.find();
        return ipAddress;
    }

    public static void main(String[] args) throws SocketException {
        System.out.println("192.168.1.1=" + IpUtils.isIP("192.168.1.1"));
        System.out.println("192.168.1.0=" + IpUtils.isIP("192.168.1.0"));
        System.out.println("127.0.0.1=" + IpUtils.isIP("127.0.0.1"));
        System.out.println("202.103.224.68=" + IpUtils.isIP("202.103.224.68"));
        System.out.println("255.255.255.255=" + IpUtils.isIP("255.255.255.255"));
        System.out.println("asdfas=" + IpUtils.isIP("243rwq"));
    }
}

