/*
 * Decompiled with CFR 0.152.
 */
package org.september.simpleweb.controller;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.september.simpleweb.auth.PublicMethod;
import org.september.simpleweb.model.ResponseVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/logger"})
public class LoggerController {
    protected static final Logger Logger = LoggerFactory.getLogger(LoggerController.class);

    @RequestMapping(value={"/loggerList"})
    public ModelAndView loggerList() {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @PublicMethod
    @RequestMapping(value={"/listLoggerData"})
    @ResponseBody
    public ResponseVo<List<JSONObject>> listConfigItemData(String filter) {
        try {
            StaticLoggerBinder loggerBinder = StaticLoggerBinder.getSingleton();
            Field field = loggerBinder.getClass().getDeclaredField("defaultLoggerContext");
            field.setAccessible(true);
            LoggerContext loggerContext = (LoggerContext)field.get(loggerBinder);
            ArrayList<JSONObject> loggerList = new ArrayList<JSONObject>();
            for (ch.qos.logback.classic.Logger logger : loggerContext.getLoggerList()) {
                JSONObject obj = new JSONObject();
                if ("ROOT".equalsIgnoreCase(logger.getName()) || !StringUtils.isEmpty((Object)filter) && !logger.getName().contains(filter)) continue;
                obj.put("name", (Object)logger.getName());
                obj.put("level", (Object)logger.getEffectiveLevel().levelStr);
                loggerList.add(obj);
            }
            return ResponseVo.BUILDER().setData(loggerList).setCode(0);
        }
        catch (Exception ex) {
            return ResponseVo.BUILDER().setDesc(ex.getMessage()).setCode(-1);
        }
    }

    @RequestMapping(value={"/doUpdateLogger"})
    @ResponseBody
    public ResponseVo<String> doUpdateLogger(String name, String level) throws IOException {
        Logger log = LoggerFactory.getLogger((String)name);
        if (!(log instanceof ch.qos.logback.classic.Logger)) {
            return ResponseVo.BUILDER().setDesc("you are not using logback").setCode(-1);
        }
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)log;
        logger.setLevel(Level.toLevel((String)level));
        return ResponseVo.BUILDER().setData("").setCode(0);
    }
}

