/*
 * Decompiled with CFR 0.152.
 */
package org.september.simpleweb.auth;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.september.simpleweb.auth.AjaxAuthenticationEntryPoint;
import org.september.simpleweb.auth.PublicMethod;
import org.september.simpleweb.model.ResponseVo;
import org.september.simpleweb.utils.SessionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class SimpleWebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private AjaxAuthenticationEntryPoint ajaxAuthenticationEntryPoint;
    @Autowired
    protected WebApplicationContext applicationContext;

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/assets/**"});
        web.ignoring().antMatchers(new String[]{"/login"});
        web.ignoring().antMatchers(new String[]{"/favicon.ico"});
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        Map map = mapping.getHandlerMethods();
        for (Map.Entry entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            HandlerMethod mappingInfoValue = (HandlerMethod)entry.getValue();
            Method method = mappingInfoValue.getMethod();
            PublicMethod publicAnno = method.getDeclaringClass().getAnnotation(PublicMethod.class);
            if (publicAnno == null) {
                publicAnno = method.getAnnotation(PublicMethod.class);
            }
            if (publicAnno == null) continue;
            String url = (String)requestMappingInfo.getPatternsCondition().getPatterns().iterator().next();
            web.ignoring().antMatchers(new String[]{url});
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.formLogin().and()).sessionManagement().maximumSessions(3).and().and()).logout().logoutUrl("/logout").and()).formLogin().loginPage("/login?forward=true").successHandler(new AuthenticationSuccessHandler(){

            public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
                ResponseVo<Map> res = ResponseVo.BUILDER().setData(SessionHelper.getLoginReturnData()).setCode(0);
                response.setContentType("application/json;charset=utf-8");
                SessionHelper.setSessionUser(authentication.getPrincipal());
                PrintWriter out = response.getWriter();
                out.write(JSONObject.toJSONString(res));
                out.flush();
                out.close();
            }
        })).failureHandler(new AuthenticationFailureHandler(){

            public void onAuthenticationFailure(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationException e) throws IOException, ServletException {
                httpServletResponse.setContentType("application/json;charset=utf-8");
                ResponseVo res = ResponseVo.BUILDER().setDesc(e.getMessage()).setCode(-1);
                PrintWriter out = httpServletResponse.getWriter();
                out.write(JSONObject.toJSONString(res));
                out.flush();
                out.close();
            }
        })).loginProcessingUrl("/doLogin")).and()).logout().logoutUrl("/logout").and()).exceptionHandling().defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)this.ajaxAuthenticationEntryPoint, new RequestMatcher(){

            public boolean matches(HttpServletRequest request) {
                return "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
            }
        }).and();
        http.csrf().disable();
        http.headers().frameOptions().disable();
        CharacterEncodingFilter filter = new CharacterEncodingFilter();
        filter.setEncoding("UTF-8");
        filter.setForceEncoding(true);
        http.addFilterBefore((Filter)filter, CsrfFilter.class);
    }
}

