/*
 * Decompiled with CFR 0.152.
 */
package org.september.core.util;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAUtils {
    public static final String RAS_Key_Private = "RAS_Key_Private";
    public static final String RAS_Key_Public = "RAS_Key_Public";
    public static final String RAS_Cache = "RAS_Cache";
    public static final String RAS_Key = "RAS_Key";

    private RSAUtils() {
    }

    public static HashMap<String, Object> getKeys() throws NoSuchAlgorithmException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", RSAUtils.getProvider());
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        map.put(RAS_Key_Public, publicKey);
        map.put(RAS_Key_Private, privateKey);
        return map;
    }

    public static RSAPublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", RSAUtils.getProvider());
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RSAPrivateKey getPrivateKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", RSAUtils.getProvider());
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(b1, b2);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptByPublicKey(String data, RSAPublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA", RSAUtils.getProvider());
        cipher.init(1, publicKey);
        int keyLen = publicKey.getModulus().bitLength() / 8;
        String[] datas = RSAUtils.splitString(data, keyLen - 11);
        String mi = "";
        for (String s : datas) {
            mi = mi + RSAUtils.bcd2Str(cipher.doFinal(s.getBytes()));
        }
        return mi;
    }

    public static String decryptByPrivateKey(String data, RSAPrivateKey privateKey) throws Exception {
        byte[][] arrays;
        Cipher cipher = Cipher.getInstance("RSA", RSAUtils.getProvider());
        cipher.init(2, privateKey);
        int keyLen = privateKey.getModulus().bitLength() / 8;
        byte[] bytes = data.getBytes();
        byte[] bcd = RSAUtils.ASCIIToBCD(bytes, bytes.length);
        String ming = "";
        for (byte[] arr : arrays = RSAUtils.splitArray(bcd, keyLen)) {
            ming = ming + new String(cipher.doFinal(arr));
        }
        return ming;
    }

    public static byte[] ASCIIToBCD(byte[] ascii, int asc_len) {
        byte[] bcd = new byte[asc_len / 2];
        int j = 0;
        for (int i = 0; i < (asc_len + 1) / 2; ++i) {
            bcd[i] = RSAUtils.ascToBcd(ascii[j++]);
            bcd[i] = (byte)((j >= asc_len ? (byte)0 : RSAUtils.ascToBcd(ascii[j++])) + (bcd[i] << 4));
        }
        return bcd;
    }

    public static byte ascToBcd(byte asc) {
        byte bcd = asc >= 48 && asc <= 57 ? (byte)(asc - 48) : (asc >= 65 && asc <= 70 ? (byte)(asc - 65 + 10) : (asc >= 97 && asc <= 102 ? (byte)(asc - 97 + 10) : (byte)(asc - 48)));
        return bcd;
    }

    public static String bcd2Str(byte[] bytes) {
        char[] temp = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            char val = (char)((bytes[i] & 0xF0) >> 4 & 0xF);
            temp[i * 2] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
            val = (char)(bytes[i] & 0xF);
            temp[i * 2 + 1] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
        }
        return new String(temp);
    }

    public static String[] splitString(String string, int len) {
        int x = string.length() / len;
        int y = string.length() % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        String[] strings = new String[x + z];
        String str = "";
        for (int i = 0; i < x + z; ++i) {
            str = i == x + z - 1 && y != 0 ? string.substring(i * len, i * len + y) : string.substring(i * len, i * len + len);
            strings[i] = str;
        }
        return strings;
    }

    public static byte[][] splitArray(byte[] data, int len) {
        int x = data.length / len;
        int y = data.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(data, i * len, arr, 0, y);
            } else {
                System.arraycopy(data, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    private static Provider getProvider() {
        return new BouncyCastleProvider();
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> map = RSAUtils.getKeys();
        RSAPublicKey publicKey = (RSAPublicKey)map.get(RAS_Key_Public);
        RSAPrivateKey privateKey = (RSAPrivateKey)map.get(RAS_Key_Private);
        String modulus = publicKey.getModulus().toString();
        System.out.println("pubkey modulus=" + modulus);
        String public_exponent = publicKey.getPublicExponent().toString();
        System.out.println("pubkey exponent=" + public_exponent);
        String private_exponent = privateKey.getPrivateExponent().toString();
        System.out.println("private exponent=" + private_exponent);
        String ming = "111";
        RSAPublicKey pubKey = RSAUtils.getPublicKey(modulus, public_exponent);
        RSAPrivateKey priKey = RSAUtils.getPrivateKey(modulus, private_exponent);
        String mi = RSAUtils.encryptByPublicKey(ming, pubKey);
        System.err.println("mi=" + mi);
        String ming2 = RSAUtils.decryptByPrivateKey(mi, priKey);
        System.err.println("ming2=" + ming2);
    }
}

