/*
 * Decompiled with CFR 0.152.
 */
package org.september.core.util;

import java.util.Date;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class PasswordUtil {
    public static final String[] word = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "j", "k", "m", "n", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final String[] num = new String[]{"2", "3", "4", "5", "6", "7", "8", "9"};

    public static String randomPassword() {
        Random random = new Random(new Date().getTime());
        int length = random.nextInt(3) + 8;
        return PasswordUtil.randomPassword(length);
    }

    public static String randomPassword(int length) {
        StringBuffer stringBuffer = new StringBuffer();
        Random random = new Random(new Date().getTime());
        boolean flag = false;
        for (int i = 0; i < length; ++i) {
            if (flag) {
                stringBuffer.append(num[random.nextInt(num.length)]);
            } else {
                stringBuffer.append(word[random.nextInt(word.length)]);
            }
            flag = !flag;
        }
        return stringBuffer.toString();
    }

    public static boolean isComplexPwd(String pwd) {
        if (StringUtils.isEmpty((Object)pwd)) {
            return false;
        }
        if (pwd.length() < 8) {
            return false;
        }
        int parts = 0;
        if (PasswordUtil.isContainNumber(pwd)) {
            ++parts;
        }
        if (PasswordUtil.isContainLowCaseLetter(pwd)) {
            ++parts;
        }
        if (PasswordUtil.isContainUpCaseLetter(pwd)) {
            ++parts;
        }
        String tmp = pwd.replaceAll("[0-9]", "");
        tmp = tmp.replaceAll("[a-z]", "");
        if (!StringUtils.isEmpty((Object)(tmp = tmp.replaceAll("[A-Z]", "")))) {
            ++parts;
        }
        return parts >= 2;
    }

    private static boolean isContainNumber(String text) {
        Pattern p = Pattern.compile("[0-9]");
        Matcher m = p.matcher(text);
        return m.find();
    }

    private static boolean isContainLowCaseLetter(String text) {
        Pattern p = Pattern.compile("[a-z]");
        Matcher m = p.matcher(text);
        return m.find();
    }

    private static boolean isContainUpCaseLetter(String text) {
        Pattern p = Pattern.compile("[A-Z]");
        Matcher m = p.matcher(text);
        return m.find();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(PasswordUtil.randomPassword());
        Thread.sleep(100L);
        System.out.println(PasswordUtil.randomPassword());
        Thread.sleep(100L);
        System.out.println(PasswordUtil.randomPassword());
    }
}

