/*
 * Decompiled with CFR 0.152.
 */
package org.september.core.component;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.september.core.component.log.LogHelper;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.UrlResource;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.StringUtils;

public class EmailService {
    protected final LogHelper logHelper = LogHelper.getLogger(this.getClass());
    private String host;
    private Pattern emailPattern = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");

    public boolean sendEmail(String sender, String senderPwd, String subject, String content, String ... to) {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(this.host);
        mailSender.setUsername(sender);
        mailSender.setPassword(senderPwd);
        mailSender.setDefaultEncoding("utf-8");
        Properties prop = new Properties();
        prop.setProperty("mail.smtp.auth", "true");
        mailSender.setJavaMailProperties(prop);
        return this.innerSend((JavaMailSender)mailSender, sender, subject, content, to, null, null);
    }

    private boolean innerSend(JavaMailSender eSender, String from, String subject, String content, String[] to, String[] attachmentUrl, String[] attachmentName) {
        return this.innerSend(eSender, from, subject, content, to, attachmentUrl, attachmentName, "", new String[0]);
    }

    private boolean innerSend(JavaMailSender eSender, String from, String subject, String content, String[] to, String[] attachmentUrl, String[] attachmentName, String senderName, String[] ccList) {
        if (StringUtils.isEmpty((Object)from)) {
            this.logHelper.getBuilder().error("\u53d1\u4ef6\u4eba\u4e3a\u7a7a\uff0c\u53d1\u9001\u5931\u8d25");
            return false;
        }
        if (to == null || to.length < 1) {
            this.logHelper.getBuilder().error("\u6536\u4ef6\u4eba\u4e3a\u7a7a\uff0c\u53d1\u9001\u5931\u8d25");
            return false;
        }
        MimeMessage message = eSender.createMimeMessage();
        try {
            MimeMessageHelper helper = null;
            if (attachmentUrl != null && attachmentName != null && attachmentUrl.length == attachmentName.length) {
                helper = new MimeMessageHelper(message, true);
                for (int i = 0; i < attachmentUrl.length; ++i) {
                    URL url = new URL(attachmentUrl[i]);
                    UrlResource src = new UrlResource(url);
                    helper.addAttachment(attachmentName[i], (InputStreamSource)src);
                }
            } else {
                helper = new MimeMessageHelper(message);
            }
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            if (StringUtils.isEmpty((Object)senderName)) {
                helper.setFrom(from);
            } else {
                try {
                    helper.setFrom(from, senderName);
                }
                catch (UnsupportedEncodingException e) {
                    this.logHelper.getBuilder().error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u53d1\u9001\u4eba\u6635\u79f0\u7f16\u7801\u9519\u8bef\u3002from:" + from + ", to:" + to + ", subject:" + subject, e);
                    helper.setFrom(from);
                }
            }
            if (ccList != null) {
                helper.setCc(ccList);
            }
            eSender.send(message);
        }
        catch (MailException e) {
            this.logHelper.getBuilder().error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\u3002from:" + from + ", to:" + to + ", subject:" + subject, e);
            return false;
        }
        catch (MessagingException e) {
            this.logHelper.getBuilder().error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\u3002from:" + from + ", to:" + to + ", subject:" + subject, e);
            return false;
        }
        catch (MalformedURLException e) {
            this.logHelper.getBuilder().error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25(\u9644\u4ef6URL\u4e0d\u6b63\u786e)\u3002from:" + from + ", to:" + to + ", attachmentUrl:" + String.join((CharSequence)",", attachmentUrl), e);
            return false;
        }
        this.logHelper.getBuilder().info("\u53d1\u9001\u90ae\u4ef6\u6210\u529f\u3002from:" + from + ", to:" + to + ", subject:" + subject);
        return true;
    }

    public boolean sendEmail(String sender, String senderPwd, String subject, String content, String senderName, String[] to, String[] ccList) {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(this.host);
        mailSender.setUsername(sender);
        mailSender.setPassword(senderPwd);
        mailSender.setDefaultEncoding("utf-8");
        Properties prop = new Properties();
        prop.setProperty("mail.smtp.auth", "true");
        mailSender.setJavaMailProperties(prop);
        return this.innerSend((JavaMailSender)mailSender, sender, subject, content, to, null, null, senderName, ccList);
    }

    public boolean sendEmailBySender(JavaMailSender mailSender, String subject, String content, String[] to, String[] attachmentUrl, String[] attachmentName, String senderName, String[] ccList) {
        JavaMailSenderImpl impl = (JavaMailSenderImpl)mailSender;
        String from = impl.getJavaMailProperties().getProperty("default_from");
        return this.innerSend(mailSender, from, subject, content, to, attachmentUrl, attachmentName, senderName, ccList);
    }

    public boolean sendEmailBySender(JavaMailSender mailSender, String subject, String content, String senderName, String[] to, String[] ccList) {
        JavaMailSenderImpl impl = (JavaMailSenderImpl)mailSender;
        String from = impl.getJavaMailProperties().getProperty("default_from");
        return this.innerSend(mailSender, from, subject, content, to, null, null, senderName, ccList);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean testEmailAddress(String email) {
        if (StringUtils.isEmpty((Object)email)) {
            return false;
        }
        Matcher matcher = this.emailPattern.matcher(email);
        return matcher.find();
    }
}

