/*
 * Decompiled with CFR 0.152.
 */
package org.september.core.component;

import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.september.core.exception.BusinessException;
import org.springframework.util.StringUtils;

public class AESService {
    private String securitySeed = "af5e357380bed52e7a09c217c41cf214";
    private KeyGenerator keyGenerator;
    private SecretKey secretKey;
    private byte[] keyBytes;
    private Key key;
    private Cipher cipher;

    public AESService(String securitySeed) throws Exception {
        if (!StringUtils.isEmpty((Object)securitySeed)) {
            this.securitySeed = securitySeed;
        }
        this.keyGenerator = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(this.securitySeed.getBytes());
        this.keyGenerator.init(128, random);
        this.secretKey = this.keyGenerator.generateKey();
        this.keyBytes = this.secretKey.getEncoded();
        this.key = new SecretKeySpec(this.keyBytes, "AES");
        this.cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
    }

    public String encrypt(String text) throws Exception {
        if (StringUtils.isEmpty((Object)text)) {
            return text;
        }
        this.cipher.init(1, this.key);
        byte[] encodeResult = this.cipher.doFinal(text.getBytes());
        return Hex.encodeHexString((byte[])encodeResult);
    }

    public String decrypt(String text) throws Exception {
        if (StringUtils.isEmpty((Object)text)) {
            return text;
        }
        try {
            this.cipher.init(2, this.key);
            byte[] decodeResult = this.cipher.doFinal(Hex.decodeHex((char[])text.toCharArray()));
            return new String(decodeResult);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BusinessException("\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25" + ex.getMessage());
        }
    }
}

