/*
 * Decompiled with CFR 0.152.
 */
package org.september.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.springframework.util.StringUtils;

public class StringExtUtil {
    public static String underlineToCamelhump(String inputString) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        int i = 0;
        while (i < inputString.length()) {
            char c = inputString.charAt(i);
            if (c == '_') {
                if (sb.length() > 0) {
                    nextUpperCase = true;
                }
            } else if (nextUpperCase) {
                sb.append(Character.toUpperCase(c));
                nextUpperCase = false;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isEmpty(Object str) {
        if (str == null) {
            return true;
        }
        return "".equals(str);
    }

    public static boolean isNotEmpty(Object str) {
        return !StringExtUtil.isEmpty(str);
    }

    public static List<String> findMatch(String text, String start, String end) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringExtUtil.isEmpty(text) || StringExtUtil.isEmpty(end) || StringExtUtil.isEmpty(end)) {
            return result;
        }
        int fromIndex = 0;
        while (fromIndex < text.length()) {
            int x = text.indexOf(start, fromIndex);
            if (x == -1) {
                return result;
            }
            int y = text.indexOf(end, x += start.length());
            if (y == -1) {
                return result;
            }
            fromIndex = y + end.length();
            result.add(text.substring(x, y));
        }
        return result;
    }

    public static String findFirstMatch(String text, String start, String end) {
        List<String> result = StringExtUtil.findMatch(text, start, end);
        if (result.isEmpty()) {
            return "";
        }
        return result.get(0);
    }

    public static String findLastMatch(String text, String start, String end) {
        List<String> result = StringExtUtil.findMatch(text, start, end);
        if (result.isEmpty()) {
            return "";
        }
        return result.get(result.size() - 1);
    }

    public static String subString(String source, int start, int length) {
        int endPos;
        if (StringExtUtil.isEmpty(source)) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (length < 0) {
            length = 0;
        }
        if ((endPos = start + length) > source.length()) {
            endPos = source.length();
        }
        return source.substring(start, endPos);
    }

    public static void tohalfAngle(String source) {
    }

    public static boolean isNumber(Object str) {
        if (StringExtUtil.isEmpty(str)) {
            return false;
        }
        if (!(str instanceof String)) {
            return false;
        }
        try {
            Double.valueOf(str.toString());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static boolean isDecimal(Object str) {
        if (StringExtUtil.isEmpty(str)) {
            return false;
        }
        if (!(str instanceof String)) {
            return false;
        }
        try {
            Double dvalue = Double.valueOf(str.toString());
            if (dvalue - (double)dvalue.longValue() == 0.0) {
                return str.toString().contains(".");
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static final boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static final boolean isAllChinese(String strName) {
        if (StringExtUtil.isEmpty(strName)) {
            return false;
        }
        char[] ch = strName.toCharArray();
        int i = 0;
        while (i < ch.length) {
            char c = ch[i];
            if (!StringExtUtil.isChinese(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean hasChinese(String str) {
        if (StringExtUtil.isEmpty(str)) {
            return false;
        }
        char[] charArray = str.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (StringExtUtil.isChinese(charArray[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEmail(String str) {
        if (StringExtUtil.isEmpty(str)) {
            return false;
        }
        boolean tag = true;
        if (!str.matches("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+")) {
            tag = false;
        }
        return tag;
    }

    public static InputStream toInputStream(String text) {
        if (StringExtUtil.isEmpty(text)) {
            return null;
        }
        return IOUtils.toInputStream((String)text);
    }

    public static String toString(InputStream is) throws IOException {
        return IOUtils.toString((InputStream)is);
    }

    public static void main(String[] args) {
        System.out.println(StringExtUtil.findMatch("${name} , ${text}", "${", "}"));
        System.out.println(StringExtUtil.findFirstMatch("${name} , ${text}", "${", "}"));
        System.out.println(StringExtUtil.findLastMatch("${name} , ${text}", "${", "}"));
        System.out.println(StringExtUtil.subString("abcdefg", 5, -1));
        System.out.println(StringExtUtil.isDecimal("056.0"));
        System.out.println(StringExtUtil.isNumber("056.0"));
        System.out.println(StringExtUtil.hasChinese("056.0\uff01"));
        System.out.println(StringExtUtil.isAllChinese("\u4ef6\u4e86\uff01\uffe5\uff08"));
        System.out.println(StringExtUtil.isEmail("253187898"));
        System.out.println(StringExtUtil.isEmail("253187898@qq.sd.com"));
    }

    public static boolean safeEquals(String secret, String secretCode) {
        if (secret == null || secretCode == null) {
            return false;
        }
        return secret.equals(secretCode);
    }

    public static boolean safeEqualsIgnoreCase(String secret, String secretCode) {
        if (secret == null || secretCode == null) {
            return false;
        }
        return secret.equalsIgnoreCase(secretCode);
    }

    public static List<Long> sperateToLongList(String data, String seprator) {
        if (data == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        String[] stringArray = data.split(seprator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (!StringUtils.isEmpty((Object)str)) {
                list.add(Long.valueOf(str));
            }
            ++n2;
        }
        return list;
    }
}

