/*
 * Decompiled with CFR 0.152.
 */
package org.september.core.component.log;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public final class LogBuilder {
    private Random random = new Random();
    Map<String, String> attrs = new HashMap<String, String>();
    private static final String Msg_Body = "__body";
    private Logger logger;

    public LogBuilder(Logger logger) {
        this.logger = logger;
    }

    protected String toHeaderString() {
        return JSON.toJSONString(this.attrs);
    }

    public LogBuilder tag(String key, String value) {
        this.attrs.put(key, value);
        return this;
    }

    public void alarm(String msg) {
        this.tag("alarm", "true");
        this.tag(Msg_Body, msg);
        this.logger.warn(this.toHeaderString());
    }

    public void info(String msg) {
        this.tag(Msg_Body, msg);
        this.logger.info(this.toHeaderString());
    }

    public void info(String msg, Object ... paramArrayOfObject) {
        this.tag(Msg_Body, MessageFormatter.arrayFormat((String)msg, (Object[])paramArrayOfObject).getMessage());
        this.logger.info(this.toHeaderString());
    }

    public void info(float percent, String msg, Object ... paramArrayOfObject) {
        if (percent < 0.0f) {
            return;
        }
        if (percent >= 1.0f) {
            this.info(msg, paramArrayOfObject);
            return;
        }
        int num = this.random.nextInt(1000);
        if ((float)num > percent * 1000.0f) {
            return;
        }
        this.tag("__roll", String.valueOf(num));
        this.tag(Msg_Body, MessageFormatter.arrayFormat((String)msg, (Object[])paramArrayOfObject).getMessage());
        this.logger.info(this.toHeaderString());
    }

    public void info(String msg, Throwable ex) {
        this.tag(Msg_Body, msg);
        this.logger.info(this.toHeaderString(), ex);
    }

    public void debug(String msg) {
        this.tag(Msg_Body, msg);
        this.logger.debug(this.toHeaderString());
    }

    public void debug(String msg, Object ... paramArrayOfObject) {
        this.tag(Msg_Body, MessageFormatter.arrayFormat((String)msg, (Object[])paramArrayOfObject).getMessage());
        this.logger.debug(this.toHeaderString());
    }

    public void debug(String msg, Throwable ex) {
        this.tag(Msg_Body, msg);
        this.logger.debug(this.toHeaderString(), ex);
    }

    public void warn(String msg) {
        this.tag(Msg_Body, msg);
        this.logger.warn(this.toHeaderString());
    }

    public void warn(String msg, Object ... paramArrayOfObject) {
        this.tag(Msg_Body, MessageFormatter.arrayFormat((String)msg, (Object[])paramArrayOfObject).getMessage());
        this.logger.warn(this.toHeaderString());
    }

    public void warn(String msg, Throwable ex) {
        this.tag(Msg_Body, msg);
        this.logger.warn(this.toHeaderString(), ex);
    }

    public void warn(String msg, Throwable ex, Object ... paramArrayOfObject) {
        this.tag(Msg_Body, MessageFormatter.arrayFormat((String)msg, (Object[])paramArrayOfObject).getMessage());
        this.logger.warn(this.toHeaderString(), ex);
    }

    public void error(String msg) {
        this.tag(Msg_Body, msg);
        this.logger.error(this.toHeaderString());
    }

    public void error(String msg, Object ... paramArrayOfObject) {
        this.tag(Msg_Body, MessageFormatter.arrayFormat((String)msg, (Object[])paramArrayOfObject).getMessage());
        this.logger.error(this.toHeaderString());
    }

    public void error(String msg, Throwable ex) {
        this.tag(Msg_Body, msg);
        this.logger.error(this.toHeaderString(), ex);
    }

    public void error(String msg, Throwable ex, Object ... paramArrayOfObject) {
        this.tag(Msg_Body, MessageFormatter.arrayFormat((String)msg, (Object[])paramArrayOfObject).getMessage());
        this.logger.error(this.toHeaderString(), ex);
    }
}

