/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.EmbeddingLayer;
import org.deeplearning4j.nn.modelimport.keras.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.UnsupportedKerasConfigurationException;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasEmbedding
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasEmbedding.class);
    public static final String LAYER_FIELD_INPUT_DIM = "input_dim";
    public static final int NUM_TRAINABLE_PARAMS = 1;
    public static final String KERAS_PARAM_NAME_W = "W";
    public static final String KERAS_PARAM_NAME_B = "b";

    public KerasEmbedding(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasEmbedding(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        int inputDim = this.getInputDimFromConfig(layerConfig);
        int[] inputShapeOld = this.inputShape;
        this.inputShape = new int[inputShapeOld.length + 1];
        this.inputShape[0] = inputShapeOld[0];
        this.inputShape[1] = inputDim;
        if (enforceTrainingConfig) {
            throw new UnsupportedKerasConfigurationException("DL4J EmbeddingLayer includes bias but Keras Embedding does not");
        }
        log.warn("DL4J EmbeddingLayer includes bias but Keras Embedding does not.");
        this.layer = ((EmbeddingLayer.Builder)((EmbeddingLayer.Builder)((EmbeddingLayer.Builder)((EmbeddingLayer.Builder)((EmbeddingLayer.Builder)((EmbeddingLayer.Builder)((EmbeddingLayer.Builder)((EmbeddingLayer.Builder)((EmbeddingLayer.Builder)new EmbeddingLayer.Builder().name(this.layerName)).nIn(inputDim)).nOut(KerasEmbedding.getNOutFromConfig(layerConfig))).dropOut(this.dropout)).activation(Activation.IDENTITY)).weightInit(this.getWeightInitFromConfig(layerConfig, enforceTrainingConfig))).biasInit(0.0)).l1(this.weightL1Regularization)).l2(this.weightL2Regularization)).build();
    }

    public EmbeddingLayer getEmbeddingLayer() {
        return (EmbeddingLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        InputPreProcessor preprocessor = this.getInputPreprocessor(inputType[0]);
        if (preprocessor != null) {
            return this.getEmbeddingLayer().getOutputType(-1, preprocessor.getOutputType(inputType[0]));
        }
        return this.getEmbeddingLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public int getNumParams() {
        return 1;
    }

    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        this.weights = new HashMap();
        if (!weights.containsKey(KERAS_PARAM_NAME_W)) {
            throw new InvalidKerasConfigurationException("Parameter W does not exist in weights");
        }
        INDArray W = weights.get(KERAS_PARAM_NAME_W);
        if (!weights.containsKey(KERAS_PARAM_NAME_B)) {
            log.warn("Setting DL4J EmbeddingLayer bias to zero.");
            weights.put(KERAS_PARAM_NAME_B, Nd4j.zeros((int)W.size(1)));
        }
        this.weights.put(KERAS_PARAM_NAME_W, W);
        this.weights.put(KERAS_PARAM_NAME_B, weights.get(KERAS_PARAM_NAME_B));
        if (weights.size() > 2) {
            Set<String> paramNames = weights.keySet();
            paramNames.remove(KERAS_PARAM_NAME_W);
            String unknownParamNames = paramNames.toString();
            log.warn("Attemping to set weights for unknown parameters: " + unknownParamNames.substring(1, unknownParamNames.length() - 1));
        }
    }

    private int getInputDimFromConfig(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasEmbedding.getInnerLayerConfigFromConfig(layerConfig);
        if (!innerConfig.containsKey(LAYER_FIELD_INPUT_DIM)) {
            throw new InvalidKerasConfigurationException("Keras Embedding layer config missing input_dim field");
        }
        return (Integer)innerConfig.get(LAYER_FIELD_INPUT_DIM);
    }
}

