/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.status;

import com.dji.sdk.common.SDKManager;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.mqtt.IMqttTopicService;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class StatusSubscribe {
    public static final String TOPIC = "sys/product/%s/status";
    @Resource
    private IMqttTopicService topicService;

    public void subscribe(GatewayManager gateway) {
        SDKManager.registerDevice(gateway);
        this.topicService.subscribe(String.format(TOPIC, gateway.getGatewaySn()));
    }

    public void subscribeWildcardsStatus() {
        this.topicService.subscribe(String.format(TOPIC, "+"));
    }

    public void unsubscribe(GatewayManager gateway) {
        SDKManager.logoutDevice(gateway.getGatewaySn());
        this.topicService.unsubscribe(String.format(TOPIC, gateway.getGatewaySn()));
    }
}

