/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.state;

import com.dji.sdk.cloudapi.device.DockDroneControlSource;
import com.dji.sdk.cloudapi.device.DockDroneCurrentCommanderFlightMode;
import com.dji.sdk.cloudapi.device.DockDroneCurrentRthMode;
import com.dji.sdk.cloudapi.device.DockDroneModeCodeReason;
import com.dji.sdk.cloudapi.device.DockDroneThermalSupportedPaletteStyle;
import com.dji.sdk.cloudapi.device.DockDroneWpmzVersion;
import com.dji.sdk.cloudapi.device.DockFirmwareVersion;
import com.dji.sdk.cloudapi.device.DockLiveStatus;
import com.dji.sdk.cloudapi.device.DockSilentMode;
import com.dji.sdk.cloudapi.device.DongleInfos;
import com.dji.sdk.cloudapi.device.FirmwareVersion;
import com.dji.sdk.cloudapi.device.PayloadFirmwareVersion;
import com.dji.sdk.cloudapi.device.RcDroneControlSource;
import com.dji.sdk.cloudapi.device.RcLiveStatus;
import com.dji.sdk.cloudapi.livestream.DockLivestreamAbilityUpdate;
import com.dji.sdk.cloudapi.livestream.RcLivestreamAbilityUpdate;
import com.dji.sdk.cloudapi.property.DockDroneCommanderFlightHeight;
import com.dji.sdk.cloudapi.property.DockDroneCommanderModeLostAction;
import com.dji.sdk.cloudapi.property.DockDroneOfflineMapEnable;
import com.dji.sdk.cloudapi.property.DockDroneRthMode;
import java.util.Arrays;

public enum StateDataKeyEnum {
    RC_AND_DRONE_FIRMWARE_VERSION("inboundStateRcAndDroneFirmwareVersion", FirmwareVersion.class),
    RC_LIVE_CAPACITY("inboundStateRcLiveCapacity", RcLivestreamAbilityUpdate.class),
    RC_DRONE_CONTROL_SOURCE("inboundStateRcControlSource", RcDroneControlSource.class),
    RC_LIVE_STATUS("inboundStateRcLiveStatus", RcLiveStatus.class),
    RC_PAYLOAD_FIRMWARE("inboundStateRcPayloadFirmware", PayloadFirmwareVersion.class),
    DOCK_FIRMWARE_VERSION("inboundStateDockFirmwareVersion", DockFirmwareVersion.class),
    DOCK_LIVE_CAPACITY("inboundStateDockLiveCapacity", DockLivestreamAbilityUpdate.class),
    DOCK_DRONE_CONTROL_SOURCE("inboundStateDockControlSource", DockDroneControlSource.class),
    DOCK_LIVE_STATUS("inboundStateDockLiveStatus", DockLiveStatus.class),
    DOCK_DRONE_WPMZ_VERSION("inboundStateDockDroneWpmzVersion", DockDroneWpmzVersion.class),
    DOCK_DRONE_THERMAL_SUPPORTED_PALETTE_STYLE("inboundStateDockDronePayload", DockDroneThermalSupportedPaletteStyle.class),
    DOCK_DRONE_RTH_MODE("inboundStateDockDroneRthMode", DockDroneRthMode.class),
    DOCK_DRONE_CURRENT_RTH_MODE("inboundStateDockDroneCurrentRthMode", DockDroneCurrentRthMode.class),
    DOCK_DRONE_COMMANDER_MODE_LOST_ACTION("inboundStateDockDroneCommanderModeLostAction", DockDroneCommanderModeLostAction.class),
    DOCK_DRONE_CURRENT_COMMANDER_FLIGHT_MODE("inboundStateDockDroneCurrentCommanderFlightMode", DockDroneCurrentCommanderFlightMode.class),
    DOCK_DRONE_COMMANDER_FLIGHT_HEIGHT("inboundStateDockDroneCommanderFlightHeight", DockDroneCommanderFlightHeight.class),
    DOCK_DRONE_MODE_CODE_REASON("inboundStateDockDroneModeCodeReason", DockDroneModeCodeReason.class),
    DOCK_DRONE_OFFLINE_MAP_ENABLE("inboundStateDockDroneOfflineMapEnable", DockDroneOfflineMapEnable.class),
    DOCK_AND_DRONE_DONGLE_INFOS("inboundStateDockAndDroneDongleInfos", DongleInfos.class),
    DOCK_SILENT_MODE("inboundStateDockSilentMode", DockSilentMode.class),
    UNKNOWN("default", Object.class);

    private final String channelName;
    private final Class classType;

    private StateDataKeyEnum(String channelName, Class classType) {
        this.channelName = channelName;
        this.classType = classType;
    }

    public Class getClassType() {
        return this.classType;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public static StateDataKeyEnum find(Class clazz) {
        return Arrays.stream(StateDataKeyEnum.values()).filter(keyEnum -> keyEnum.classType == clazz).findAny().orElse(UNKNOWN);
    }
}

