/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.state;

import com.dji.sdk.cloudapi.device.DockDroneControlSource;
import com.dji.sdk.cloudapi.device.DockDroneCurrentCommanderFlightMode;
import com.dji.sdk.cloudapi.device.DockDroneCurrentRthMode;
import com.dji.sdk.cloudapi.device.DockDroneModeCodeReason;
import com.dji.sdk.cloudapi.device.DockDroneThermalSupportedPaletteStyle;
import com.dji.sdk.cloudapi.device.DockDroneWpmzVersion;
import com.dji.sdk.cloudapi.device.DockFirmwareVersion;
import com.dji.sdk.cloudapi.device.DockLiveStatus;
import com.dji.sdk.cloudapi.device.DockSilentMode;
import com.dji.sdk.cloudapi.device.DongleInfos;
import com.dji.sdk.cloudapi.device.PayloadModelConst;
import com.dji.sdk.cloudapi.livestream.DockLivestreamAbilityUpdate;
import com.dji.sdk.cloudapi.property.DockDroneCommanderFlightHeight;
import com.dji.sdk.cloudapi.property.DockDroneCommanderModeLostAction;
import com.dji.sdk.cloudapi.property.DockDroneOfflineMapEnable;
import com.dji.sdk.cloudapi.property.DockDroneRthMode;
import com.dji.sdk.exception.CloudSDKException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public enum DockStateDataKeyEnum {
    FIRMWARE_VERSION(Set.of("firmware_version"), DockFirmwareVersion.class),
    LIVE_CAPACITY(Set.of("live_capacity"), DockLivestreamAbilityUpdate.class),
    CONTROL_SOURCE(Set.of("control_source"), DockDroneControlSource.class),
    LIVE_STATUS(Set.of("live_status"), DockLiveStatus.class),
    WPMZ_VERSION(Set.of("wpmz_version"), DockDroneWpmzVersion.class),
    THERMAL_SUPPORTED_PALETTE_STYLE(PayloadModelConst.getAllIndexWithPosition(), DockDroneThermalSupportedPaletteStyle.class),
    RTH_MODE(Set.of("rth_mode"), DockDroneRthMode.class),
    CURRENT_RTH_MODE(Set.of("current_rth_mode"), DockDroneCurrentRthMode.class),
    COMMANDER_MODE_LOST_ACTION(Set.of("commander_mode_lost_action"), DockDroneCommanderModeLostAction.class),
    CURRENT_COMMANDER_FLIGHT_MODE(Set.of("current_commander_flight_mode"), DockDroneCurrentCommanderFlightMode.class),
    COMMANDER_FLIGHT_HEIGHT(Set.of("commander_flight_height"), DockDroneCommanderFlightHeight.class),
    MODE_CODE_REASON(Set.of("mode_code_reason"), DockDroneModeCodeReason.class),
    OFFLINE_MAP_ENABLE(Set.of("offline_map_enable"), DockDroneOfflineMapEnable.class),
    DONGLE_INFOS(Set.of("dongle_infos"), DongleInfos.class),
    SILENT_MODE(Set.of("silent_mode"), DockSilentMode.class),
    departure_trajectory(Set.of("departure_trajectory"), DockSilentMode.class),
    wireless_link_topo(Set.of("wireless_link_topo"), DockSilentMode.class),
    cameras(Set.of("cameras"), DockSilentMode.class),
    psdk_widget_values(Set.of("psdk_widget_values"), DockSilentMode.class),
    uom_real_name_state(Set.of("uom_real_name_state"), DockSilentMode.class),
    psdk_ui_resource(Set.of("psdk_ui_resource"), DockSilentMode.class),
    payloads(Set.of("payloads"), DockSilentMode.class),
    camera_watermark_settings(Set.of("camera_watermark_settings"), DockSilentMode.class),
    flysafe_database_version(Set.of("flysafe_database_version"), DockSilentMode.class),
    commander_flight_mode(Set.of("commander_flight_mode"), DockSilentMode.class),
    geo_caging_status(Set.of("geo_caging_status"), DockSilentMode.class),
    ai_model_list(Set.of("ai_model_list"), DockSilentMode.class),
    air_transfer_enable(Set.of("air_transfer_enable"), DockSilentMode.class),
    rtcm_info(Set.of("rtcm_info"), DockSilentMode.class),
    mobility_status_notify(Set.of("mobility_status_notify"), DockSilentMode.class);

    private final Set<String> keys;
    private final Class classType;

    private DockStateDataKeyEnum(Set<String> keys, Class classType) {
        this.keys = keys;
        this.classType = classType;
    }

    public Class getClassType() {
        return this.classType;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public static DockStateDataKeyEnum find(Set<String> keys) {
        return Arrays.stream(DockStateDataKeyEnum.values()).filter(keyEnum -> !Collections.disjoint(keys, keyEnum.keys)).findAny().orElseThrow(() -> new CloudSDKException(DockStateDataKeyEnum.class, keys));
    }
}

