/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.osd;

import com.dji.sdk.cloudapi.device.OsdDock;
import com.dji.sdk.cloudapi.device.OsdDockDrone;
import com.dji.sdk.cloudapi.device.OsdRcDrone;
import com.dji.sdk.cloudapi.device.OsdRemoteControl;
import com.dji.sdk.config.version.GatewayTypeEnum;
import com.dji.sdk.exception.CloudSDKException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum OsdDeviceTypeEnum {
    RC(true, OsdRemoteControl.class, "inboundOsdRc", GatewayTypeEnum.RC),
    DOCK(true, OsdDock.class, "inboundOsdDock", GatewayTypeEnum.DOCK, GatewayTypeEnum.DOCK2),
    DOCK3(true, OsdDock.class, "inboundOsdDock", GatewayTypeEnum.DOCK, GatewayTypeEnum.DOCK3),
    DOCK3_DRONE(false, OsdDockDrone.class, "inboundOsdDockDrone", GatewayTypeEnum.DOCK, GatewayTypeEnum.DOCK3),
    RC_DRONE(false, OsdRcDrone.class, "inboundOsdRcDrone", GatewayTypeEnum.RC),
    DOCK_DRONE(false, OsdDockDrone.class, "inboundOsdDockDrone", GatewayTypeEnum.DOCK, GatewayTypeEnum.DOCK2);

    private final boolean gateway;
    private final Set<GatewayTypeEnum> gatewayType = new HashSet<GatewayTypeEnum>();
    private final Class classType;
    private final String channelName;

    private OsdDeviceTypeEnum(boolean gateway, Class classType, String channelName, GatewayTypeEnum ... gatewayType) {
        this.gateway = gateway;
        this.classType = classType;
        this.channelName = channelName;
        Collections.addAll(this.gatewayType, gatewayType);
    }

    public Set<GatewayTypeEnum> getGatewayType() {
        return this.gatewayType;
    }

    public boolean isGateway() {
        return this.gateway;
    }

    public Class getClassType() {
        return this.classType;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public static OsdDeviceTypeEnum find(GatewayTypeEnum gatewayType, boolean isGateway) {
        OsdDeviceTypeEnum type = Arrays.stream(OsdDeviceTypeEnum.values()).filter(osdEnum -> osdEnum.gatewayType.contains((Object)gatewayType) && osdEnum.gateway == isGateway).findAny().orElseThrow(() -> new CloudSDKException(OsdDeviceTypeEnum.class, new Object[]{gatewayType, isGateway}));
        return type;
    }

    public static OsdDeviceTypeEnum find(Class classType) {
        return Arrays.stream(OsdDeviceTypeEnum.values()).filter(type -> type.classType == classType).findAny().orElseThrow(() -> new CloudSDKException(OsdDeviceTypeEnum.class, classType));
    }
}

