/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.events;

import com.dji.sdk.common.Common;
import com.dji.sdk.exception.CloudSDKException;
import com.dji.sdk.mqtt.MqttGatewayPublish;
import com.dji.sdk.mqtt.events.EventsMethodEnum;
import com.dji.sdk.mqtt.events.TopicEventsRequest;
import com.dji.sdk.mqtt.events.TopicEventsResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

@Configuration
public class EventsRouter {
    @Resource
    private MqttGatewayPublish gatewayPublish;

    @Bean
    public IntegrationFlow eventsMethodRouterFlow() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((String)"inboundEvents").transform(Message.class, source -> {
            try {
                TopicEventsRequest data = (TopicEventsRequest)Common.getObjectMapper().readValue((byte[])source.getPayload(), TopicEventsRequest.class);
                String topic = String.valueOf(source.getHeaders().get((Object)"mqtt_receivedTopic"));
                return data.setFrom(topic.substring("thing/product/".length(), topic.indexOf("/events"))).setData(Common.getObjectMapper().convertValue(data.getData(), EventsMethodEnum.find(data.getMethod()).getClassType()));
            }
            catch (IOException e) {
                throw new CloudSDKException(e);
            }
        }, null)).route(response -> EventsMethodEnum.find(response.getMethod()), mapping -> Arrays.stream(EventsMethodEnum.values()).forEach(methodEnum -> mapping.channelMapping((Object)methodEnum, methodEnum.getChannelName())))).get();
    }

    @Bean
    public IntegrationFlow replySuccessEvents() {
        return ((IntegrationFlowBuilder)IntegrationFlows.from((String)"outboundEvents").handle(this::publish)).nullChannel();
    }

    private TopicEventsResponse publish(TopicEventsResponse request, MessageHeaders headers) {
        if (Objects.isNull(request) || Objects.isNull(request.getData())) {
            return null;
        }
        this.gatewayPublish.publishReply(request, headers);
        return request;
    }
}

