/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt;

import com.dji.sdk.mqtt.IMqttTopicService;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.mqtt.inbound.MqttPahoMessageDrivenChannelAdapter;
import org.springframework.stereotype.Component;

@Component
public class MqttTopicServiceImpl
implements IMqttTopicService {
    private static final Logger log = LoggerFactory.getLogger(MqttTopicServiceImpl.class);
    @Resource
    private MqttPahoMessageDrivenChannelAdapter adapter;

    @Override
    public void subscribe(String ... topics) {
        HashSet<String> topicSet = new HashSet<String>(Arrays.asList(this.getSubscribedTopic()));
        for (String topic : topics) {
            if (topicSet.contains(topic)) {
                return;
            }
            this.subscribe(topic, 1);
        }
    }

    @Override
    public void subscribe(String topic, int qos) {
        HashSet<String> topicSet = new HashSet<String>(Arrays.asList(this.getSubscribedTopic()));
        if (topicSet.contains(topic)) {
            return;
        }
        log.debug("subscribe topic: {}", (Object)topic);
        this.adapter.addTopic(topic, qos);
    }

    @Override
    public void unsubscribe(String ... topics) {
        log.debug("unsubscribe topic: {}", (Object)Arrays.toString(topics));
        this.adapter.removeTopic(topics);
    }

    @Override
    public String[] getSubscribedTopic() {
        return this.adapter.getTopic();
    }
}

