/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.common;

import com.dji.sdk.cloudapi.device.DeviceDomainEnum;
import com.dji.sdk.cloudapi.device.DeviceEnum;
import com.dji.sdk.cloudapi.device.DeviceSubTypeEnum;
import com.dji.sdk.cloudapi.device.DeviceTypeEnum;
import com.dji.sdk.config.version.Dock2ThingVersionEnum;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.config.version.GatewayTypeEnum;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class SDKManager {
    private static final ConcurrentHashMap<String, GatewayManager> SDK_MAP = new ConcurrentHashMap(16);

    private SDKManager() {
    }

    public static GatewayManager getDeviceSDK(String gatewaySn) {
        if (SDK_MAP.containsKey(gatewaySn)) {
            return SDK_MAP.get(gatewaySn);
        }
        GatewayManager gm = new GatewayManager(Objects.requireNonNull(gatewaySn), gatewaySn, GatewayTypeEnum.DOCK3, Dock2ThingVersionEnum.V1_2_5.getThingVersion(), Dock2ThingVersionEnum.V1_2_5.getThingVersion());
        SDKManager.registerDevice(gm);
        System.err.println("**************\u673a\u573a\u6ca1\u6709\u6ce8\u518c,\u5df2\u91cd\u65b0\u6ce8\u518c*****************,gatewaySn=" + gatewaySn);
        return gm;
    }

    public static GatewayManager registerDevice(String gatewaySn, String droneSn, DeviceDomainEnum domain, DeviceTypeEnum type, DeviceSubTypeEnum subType, String gatewayThingVersion, String droneThingVersion) {
        return SDKManager.registerDevice(gatewaySn, droneSn, GatewayTypeEnum.find(DeviceEnum.find(domain, type, subType)), gatewayThingVersion, droneThingVersion);
    }

    public static GatewayManager registerDevice(String gatewaySn, String droneSn, GatewayTypeEnum type, String gatewayThingVersion, String droneThingVersion) {
        return SDKManager.registerDevice(new GatewayManager(Objects.requireNonNull(gatewaySn), droneSn, type, gatewayThingVersion, droneThingVersion));
    }

    public static GatewayManager registerDevice(GatewayManager gateway) {
        SDK_MAP.put(gateway.getGatewaySn(), gateway);
        return gateway;
    }

    public static void logoutDevice(String gatewaySn) {
        SDK_MAP.remove(gatewaySn);
    }
}

