/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.wayline;

import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum BreakpointStateEnum {
    WAYLINE_SEGMENT(0, "On the wayline segment"),
    WAYPOINT(1, "On the waypoint");

    private final int state;
    private final String msg;

    private BreakpointStateEnum(int state, String msg) {
        this.state = state;
        this.msg = msg;
    }

    @JsonValue
    public int getState() {
        return this.state;
    }

    public String getMsg() {
        return this.msg;
    }

    @JsonCreator
    public static BreakpointStateEnum find(int state) {
        return Arrays.stream(BreakpointStateEnum.values()).filter(stateEnum -> stateEnum.state == state).findAny().orElseThrow(() -> new CloudSDKException(BreakpointStateEnum.class, state));
    }
}

