/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.tsa;

import com.dji.sdk.cloudapi.tsa.DeviceIconUrl;
import com.dji.sdk.cloudapi.tsa.TopologyDeviceModel;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Schema(description="device topology data")
public class DeviceTopology {
    @NotNull
    @Schema(description="device sn", example="1AEC32CK4AD23R")
    private String sn;
    @NotNull
    @JsonProperty(value="device_callsign")
    @Schema(description="device nickname", example="my M350")
    private String deviceCallsign;
    @NotNull
    @JsonProperty(value="device_model")
    @Valid
    private TopologyDeviceModel deviceModel;
    @NotNull
    @Schema(description="online status")
    @JsonProperty(value="online_status")
    private Boolean onlineStatus;
    @Schema(description="the id of the person using the device", format="uuid")
    @JsonProperty(value="user_id")
    private String userId;
    @NotNull
    @Schema(description="the nickname of the person using the device", example="admin")
    @JsonProperty(value="user_callsign")
    private String userCallsign;
    @NotNull
    @JsonProperty(value="icon_urls")
    @Valid
    private DeviceIconUrl iconUrls;

    public String toString() {
        return "DeviceTopology{sn='" + this.sn + "', deviceCallsign='" + this.deviceCallsign + "', deviceModel=" + String.valueOf(this.deviceModel) + ", onlineStatus=" + String.valueOf(this.onlineStatus) + ", userId='" + this.userId + "', userCallsign='" + this.userCallsign + "', iconUrls=" + String.valueOf(this.iconUrls) + "}";
    }

    public String getSn() {
        return this.sn;
    }

    public DeviceTopology setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public String getDeviceCallsign() {
        return this.deviceCallsign;
    }

    public DeviceTopology setDeviceCallsign(String deviceCallsign) {
        this.deviceCallsign = deviceCallsign;
        return this;
    }

    public TopologyDeviceModel getDeviceModel() {
        return this.deviceModel;
    }

    public DeviceTopology setDeviceModel(TopologyDeviceModel deviceModel) {
        this.deviceModel = deviceModel;
        return this;
    }

    public Boolean getOnlineStatus() {
        return this.onlineStatus;
    }

    public DeviceTopology setOnlineStatus(Boolean onlineStatus) {
        this.onlineStatus = onlineStatus;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public DeviceTopology setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getUserCallsign() {
        return this.userCallsign;
    }

    public DeviceTopology setUserCallsign(String userCallsign) {
        this.userCallsign = userCallsign;
        return this;
    }

    public DeviceIconUrl getIconUrls() {
        return this.iconUrls;
    }

    public DeviceTopology setIconUrls(DeviceIconUrl iconUrls) {
        this.iconUrls = iconUrls;
        return this;
    }
}

