/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.map.api;

import com.dji.sdk.annotations.CloudSDKVersion;
import com.dji.sdk.cloudapi.map.MapMethodEnum;
import com.dji.sdk.cloudapi.map.OfflineMapGetRequest;
import com.dji.sdk.cloudapi.map.OfflineMapGetResponse;
import com.dji.sdk.cloudapi.map.OfflineMapSyncProgress;
import com.dji.sdk.cloudapi.property.DockDroneOfflineMapEnable;
import com.dji.sdk.config.version.CloudSDKVersionEnum;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.config.version.GatewayTypeEnum;
import com.dji.sdk.mqtt.MqttReply;
import com.dji.sdk.mqtt.requests.TopicRequestsRequest;
import com.dji.sdk.mqtt.requests.TopicRequestsResponse;
import com.dji.sdk.mqtt.services.ServicesPublish;
import com.dji.sdk.mqtt.services.ServicesReplyData;
import com.dji.sdk.mqtt.services.TopicServicesResponse;
import com.dji.sdk.mqtt.state.TopicStateRequest;
import com.dji.sdk.mqtt.state.TopicStateResponse;
import javax.annotation.Resource;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHeaders;

public abstract class AbstractOfflineMapService {
    @Resource
    private ServicesPublish servicesPublish;

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_2_5, include={GatewayTypeEnum.DOCK3})
    @ServiceActivator(inputChannel="inboundStateDockDroneOfflineMapEnable", outputChannel="outboundState")
    public TopicStateResponse<MqttReply> dockDroneOfflineMapEnable(TopicStateRequest<DockDroneOfflineMapEnable> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("dockDroneOfflineMapEnable not implemented");
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_2_5, include={GatewayTypeEnum.DOCK3})
    public TopicServicesResponse<ServicesReplyData> offlineMapUpdate(GatewayManager gateway) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), MapMethodEnum.OFFLINE_MAP_UPDATE.getMethod());
    }

    @ServiceActivator(inputChannel="inboundEventsOfflineMapSyncProgress", outputChannel="outboundEvents")
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_1, include={GatewayTypeEnum.DOCK2})
    public TopicRequestsResponse<MqttReply> offlineMapSyncProgress(TopicRequestsRequest<OfflineMapSyncProgress> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("offlineMapSyncProgress not implemented");
    }

    @ServiceActivator(inputChannel="inboundRequestsOfflineMapGet", outputChannel="outboundRequests")
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_1, include={GatewayTypeEnum.DOCK2})
    public TopicRequestsResponse<MqttReply<OfflineMapGetResponse>> offlineMapGet(TopicRequestsRequest<OfflineMapGetRequest> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("offlineMapGet not implemented");
    }
}

