/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.map;

import com.dji.sdk.cloudapi.map.GroupTypeEnum;
import com.dji.sdk.cloudapi.map.MapGroupElement;
import com.dji.sdk.common.BaseModel;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Schema(description="element group data")
public class GetMapElementsResponse
extends BaseModel {
    @NotNull
    @Pattern(regexp="^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")
    @Schema(description="group id", format="uuid")
    private @NotNull @Pattern(regexp="^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$") String id;
    @NotNull
    @Schema(description="group name", example="Pilot Share Layer")
    private String name;
    @NotNull
    private GroupTypeEnum type;
    @NotNull
    @Schema(description="data collection of elements")
    private @NotNull List<@Valid MapGroupElement> elements;
    @JsonProperty(value="is_lock")
    @NotNull
    @Schema(description="Whether the element group is locked.")
    private Boolean lock;

    public String toString() {
        return "GetMapElementsResponse{id='" + this.id + "', name='" + this.name + "', type=" + this.type + ", elements=" + this.elements + ", lock=" + this.lock + "}";
    }

    public String getId() {
        return this.id;
    }

    public GetMapElementsResponse setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public GetMapElementsResponse setName(String name) {
        this.name = name;
        return this;
    }

    public GroupTypeEnum getType() {
        return this.type;
    }

    public GetMapElementsResponse setType(GroupTypeEnum type) {
        this.type = type;
        return this;
    }

    public List<MapGroupElement> getElements() {
        return this.elements;
    }

    public GetMapElementsResponse setElements(List<MapGroupElement> elements) {
        this.elements = elements;
        return this;
    }

    public Boolean getLock() {
        return this.lock;
    }

    public GetMapElementsResponse setLock(Boolean lock) {
        this.lock = lock;
        return this;
    }
}

