/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.control;

import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum CameraTypeEnum {
    ZOOM("zoom"),
    WIDE("wide"),
    IR("ir");

    private final String type;

    private CameraTypeEnum(String type) {
        this.type = type;
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    @JsonCreator
    public static CameraTypeEnum find(String type) {
        return Arrays.stream(CameraTypeEnum.values()).filter(typeEnum -> typeEnum.type.equals(type)).findAny().orElseThrow(() -> new CloudSDKException(CameraTypeEnum.class, type));
    }
}

