/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.state;

import com.dji.sdk.common.SDKManager;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.mqtt.IMqttTopicService;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class StateSubscribe {
    @Resource
    private IMqttTopicService topicService;
    public static final String TOPIC = "thing/product/%s/state";

    public void subscribe(GatewayManager gateway, boolean unsubscribeSubDevice) {
        SDKManager.registerDevice(gateway);
        this.topicService.subscribe(String.format(TOPIC, gateway.getGatewaySn()));
        if (unsubscribeSubDevice) {
            this.topicService.unsubscribe(String.format(TOPIC, gateway.getDroneSn()));
            return;
        }
        if (null != gateway.getDroneSn()) {
            this.topicService.subscribe(String.format(TOPIC, gateway.getDroneSn()));
        }
    }

    public void unsubscribe(GatewayManager gateway) {
        SDKManager.logoutDevice(gateway.getGatewaySn());
        this.topicService.unsubscribe(String.format(TOPIC, gateway.getGatewaySn()));
        if (null != gateway.getDroneSn()) {
            this.topicService.unsubscribe(String.format(TOPIC, gateway.getDroneSn()));
        }
    }
}

