/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.services;

import com.dji.sdk.cloudapi.control.ControlErrorCodeEnum;
import com.dji.sdk.cloudapi.debug.DebugErrorCodeEnum;
import com.dji.sdk.cloudapi.firmware.FirmwareErrorCodeEnum;
import com.dji.sdk.cloudapi.livestream.LiveErrorCodeEnum;
import com.dji.sdk.cloudapi.log.LogErrorCodeEnum;
import com.dji.sdk.cloudapi.wayline.WaylineErrorCodeEnum;
import com.dji.sdk.common.CommonErrorEnum;
import com.dji.sdk.common.ErrorCodeSourceEnum;
import com.dji.sdk.common.IErrorInfo;
import com.dji.sdk.mqtt.services.IServicesErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public class ServicesErrorCode
implements IErrorInfo {
    private static final int MOD = 100000;
    private ErrorCodeSourceEnum source;
    private IServicesErrorCode errorCode;
    private boolean success;
    private Integer sourceCode;

    public String toString() {
        return "{errorCode=" + this.getCode() + ", errorMsg=" + this.getMessage() + "}";
    }

    @JsonCreator
    public ServicesErrorCode(int code) {
        this.sourceCode = code;
        if (0 == code) {
            this.success = true;
            this.errorCode = CommonErrorEnum.SUCCESS;
            return;
        }
        this.source = ErrorCodeSourceEnum.find(code / 100000);
        this.errorCode = LiveErrorCodeEnum.find(code % 100000);
        if (this.errorCode.getCode() != -1) {
            return;
        }
        this.errorCode = DebugErrorCodeEnum.find(code);
        if (this.errorCode.getCode() != -1) {
            return;
        }
        this.errorCode = ControlErrorCodeEnum.find(code);
        if (this.errorCode.getCode() != -1) {
            return;
        }
        this.errorCode = LogErrorCodeEnum.find(code);
        if (this.errorCode.getCode() != -1) {
            return;
        }
        this.errorCode = FirmwareErrorCodeEnum.find(code);
        if (this.errorCode.getCode() != -1) {
            return;
        }
        this.errorCode = WaylineErrorCodeEnum.find(code);
        if (this.errorCode.getCode() != -1) {
            return;
        }
        this.errorCode = CommonErrorEnum.find(code);
    }

    @Override
    public String getMessage() {
        return this.errorCode.getMessage();
    }

    @Override
    @JsonValue
    public Integer getCode() {
        return this.sourceCode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ErrorCodeSourceEnum getSource() {
        return this.source;
    }
}

