/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.requests;

import com.dji.sdk.common.Common;
import com.dji.sdk.exception.CloudSDKErrorEnum;
import com.dji.sdk.exception.CloudSDKException;
import com.dji.sdk.mqtt.MqttGatewayPublish;
import com.dji.sdk.mqtt.requests.RequestsMethodEnum;
import com.dji.sdk.mqtt.requests.TopicRequestsRequest;
import com.dji.sdk.mqtt.requests.TopicRequestsResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.messaging.MessageHeaders;

@Configuration
public class RequestsRouter {
    @Resource
    private MqttGatewayPublish gatewayPublish;

    @Bean
    public IntegrationFlow requestsMethodRouterFlow() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((String)"inboundRequests").transform(payload -> {
            try {
                TopicRequestsRequest response = (TopicRequestsRequest)Common.getObjectMapper().readValue(payload, TopicRequestsRequest.class);
                return response.setData(Common.getObjectMapper().convertValue(response.getData(), RequestsMethodEnum.find(response.getMethod()).getClassType()));
            }
            catch (IOException e) {
                throw new CloudSDKException(e);
            }
        })).route(receiver -> RequestsMethodEnum.find(receiver.getMethod()), mapping -> Arrays.stream(RequestsMethodEnum.values()).forEach(methodEnum -> mapping.channelMapping((Object)methodEnum, methodEnum.getChannelName())))).get();
    }

    @Bean
    public IntegrationFlow replyRequestsMethod() {
        return ((IntegrationFlowBuilder)IntegrationFlows.from((String)"outboundRequests").handle(this::publish)).nullChannel();
    }

    private TopicRequestsResponse publish(TopicRequestsResponse request, MessageHeaders headers) {
        if (Objects.isNull(request)) {
            throw new CloudSDKException(CloudSDKErrorEnum.INVALID_PARAMETER, "The return value cannot be null.");
        }
        this.gatewayPublish.publishReply(request, headers);
        return request;
    }
}

