/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.property;

import com.dji.sdk.common.Common;
import com.dji.sdk.mqtt.Chan;
import com.dji.sdk.mqtt.property.PropertySetReplyResultEnum;
import com.dji.sdk.mqtt.property.TopicPropertySetResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Objects;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class PropertySetReplyHandler {
    private static final String RESULT_KEY = "result";

    @ServiceActivator(inputChannel="inboundPropertySetReply")
    public void propertySetReply(Message<?> message) throws IOException {
        byte[] payload = (byte[])message.getPayload();
        TopicPropertySetResponse receiver = (TopicPropertySetResponse)Common.getObjectMapper().readValue(payload, (TypeReference)new TypeReference<TopicPropertySetResponse>(){});
        Chan chan = Chan.getInstance(receiver.getTid(), false);
        if (Objects.isNull(chan)) {
            return;
        }
        receiver.setData((Object)PropertySetReplyResultEnum.find(((JsonNode)Common.getObjectMapper().convertValue(receiver.getData(), JsonNode.class)).findValue(RESULT_KEY).intValue()));
        chan.put(receiver);
    }
}

