/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt;

import com.dji.sdk.common.SpringBeanUtils;
import com.dji.sdk.mqtt.CloudApiTopicEnum;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.annotation.Router;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.stereotype.Component;

@Component
public class InboundMessageRouter
extends AbstractMessageRouter {
    private static final Logger log = LoggerFactory.getLogger(InboundMessageRouter.class);

    @Router(inputChannel="inbound")
    protected Collection<MessageChannel> determineTargetChannels(Message<?> message) {
        MessageHeaders headers = message.getHeaders();
        String topic = headers.get((Object)"mqtt_receivedTopic").toString();
        byte[] payload = (byte[])message.getPayload();
        log.debug("received topic: {} \t payload =>{}", (Object)topic, (Object)new String(payload));
        CloudApiTopicEnum topicEnum = CloudApiTopicEnum.find(topic);
        MessageChannel bean = (MessageChannel)SpringBeanUtils.getBean(topicEnum.getBeanName());
        return Collections.singleton(bean);
    }
}

