/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.config.version;

import com.dji.sdk.config.version.CloudSDKVersionEnum;
import com.dji.sdk.config.version.IThingVersion;
import com.dji.sdk.exception.CloudSDKVersionException;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DroneThingVersionEnum implements IThingVersion
{
    V1_0_0("1.0.0", CloudSDKVersionEnum.V0_0_1),
    V1_1_0("1.1.0", CloudSDKVersionEnum.V1_0_0),
    V1_1_2("1.1.2", CloudSDKVersionEnum.V1_0_0),
    V1_1_3("1.1.3", CloudSDKVersionEnum.V1_0_2),
    V1_2_0("1.2.0", CloudSDKVersionEnum.V1_0_3),
    V1_2_5("1.2.5", CloudSDKVersionEnum.V1_2_5);

    private static final Logger log;
    private final String thingVersion;
    private final CloudSDKVersionEnum cloudSDKVersion;

    private DroneThingVersionEnum(String thingVersion, CloudSDKVersionEnum cloudSDKVersion) {
        this.thingVersion = thingVersion;
        this.cloudSDKVersion = cloudSDKVersion;
    }

    @Override
    @JsonValue
    public String getThingVersion() {
        return this.thingVersion;
    }

    @Override
    public CloudSDKVersionEnum getCloudSDKVersion() {
        return this.cloudSDKVersion;
    }

    public static DroneThingVersionEnum find(String thingVersion) {
        Optional<DroneThingVersionEnum> opt = Arrays.stream(DroneThingVersionEnum.values()).filter(thingVersionEnum -> thingVersionEnum.thingVersion.equals(thingVersion)).findAny();
        if (opt.isPresent()) {
            return opt.get();
        }
        throw new CloudSDKVersionException(thingVersion);
    }

    static {
        log = LoggerFactory.getLogger(DroneThingVersionEnum.class);
    }
}

