/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.config.version;

import com.dji.sdk.config.version.CloudSDKVersionEnum;
import com.dji.sdk.config.version.IThingVersion;
import com.dji.sdk.exception.CloudSDKVersionException;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum Dock2ThingVersionEnum implements IThingVersion
{
    V1_1_2("1.1.2", CloudSDKVersionEnum.V1_0_1),
    V1_2_0("1.2.0", CloudSDKVersionEnum.V1_0_3),
    V1_2_5("1.2.5", CloudSDKVersionEnum.V1_2_5);

    private final String thingVersion;
    private final CloudSDKVersionEnum cloudSDKVersion;

    private Dock2ThingVersionEnum(String thingVersion, CloudSDKVersionEnum cloudSDKVersion) {
        this.thingVersion = thingVersion;
        this.cloudSDKVersion = cloudSDKVersion;
    }

    @Override
    @JsonValue
    public String getThingVersion() {
        return this.thingVersion;
    }

    @Override
    public CloudSDKVersionEnum getCloudSDKVersion() {
        return this.cloudSDKVersion;
    }

    public static Dock2ThingVersionEnum find(String thingVersion) {
        return Arrays.stream(Dock2ThingVersionEnum.values()).filter(thingVersionEnum -> thingVersionEnum.thingVersion.equals(thingVersion)).findAny().orElseThrow(() -> new CloudSDKVersionException(thingVersion));
    }
}

