/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.common;

import com.dji.sdk.common.IErrorInfo;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="The data format of the http response.")
public class HttpResultResponse<T> {
    public static final int CODE_SUCCESS = 0;
    public static final int CODE_FAILED = -1;
    public static final String MESSAGE_SUCCESS = "success";
    public static final String MESSAGE_FAILED = "failed";
    @Schema(description="0 means success, non-zero means error.", example="0")
    private int code;
    @Schema(description="The response message.", example="success")
    private String message;
    private String desc;
    @Schema(description="The response data.")
    private T data;

    public String toString() {
        return "HttpResultResponse{code=" + this.code + ", message='" + this.message + "', data=" + this.data + "}";
    }

    public int getCode() {
        return this.code;
    }

    public HttpResultResponse<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public HttpResultResponse<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public HttpResultResponse<T> setData(T data) {
        this.data = data;
        return this;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static HttpResultResponse success() {
        return new HttpResultResponse().setCode(0).setMessage(MESSAGE_SUCCESS).setData("");
    }

    public static <T> HttpResultResponse<T> success(T data) {
        return HttpResultResponse.success().setData(data);
    }

    public static HttpResultResponse error() {
        return new HttpResultResponse().setCode(-1).setMessage(MESSAGE_FAILED);
    }

    public static HttpResultResponse error(String message) {
        return new HttpResultResponse().setCode(-1).setMessage(message);
    }

    public static HttpResultResponse error(int code, String message) {
        return new HttpResultResponse().setCode(code).setMessage(message);
    }

    public static HttpResultResponse error(IErrorInfo errorInfo) {
        return new HttpResultResponse().setCode(errorInfo.getCode()).setMessage(errorInfo.getMessage());
    }
}

