/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.common;

import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum ErrorCodeSourceEnum {
    Other(0),
    DEVICE(3),
    DOCK(5),
    PILOT(6);

    private final int source;

    private ErrorCodeSourceEnum(int source) {
        this.source = source;
    }

    @JsonValue
    public int getSource() {
        return this.source;
    }

    @JsonCreator
    public static ErrorCodeSourceEnum find(int source) {
        return Arrays.stream(ErrorCodeSourceEnum.values()).filter(error -> error.source == source).findAny().orElseThrow(() -> new CloudSDKException(ErrorCodeSourceEnum.class, source));
    }
}

