/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.wayline;

import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum FlighttaskStatusEnum {
    SENT("sent", false),
    IN_PROGRESS("in_progress", false),
    OK("ok", true),
    PAUSED("paused", false),
    REJECTED("rejected", true),
    FAILED("failed", true),
    CANCELED("canceled", true),
    TIMEOUT("timeout", true),
    PARTIALLY_DONE("partially_done", true);

    private final String status;
    private final boolean end;

    private FlighttaskStatusEnum(String status, boolean end) {
        this.status = status;
        this.end = end;
    }

    @JsonValue
    public String getStatus() {
        return this.status;
    }

    public boolean isEnd() {
        return this.end;
    }

    @JsonCreator
    public static FlighttaskStatusEnum find(String status) {
        return Arrays.stream(FlighttaskStatusEnum.values()).filter(statusEnum -> statusEnum.status.equals(status)).findAny().orElseThrow(() -> new CloudSDKException(FlighttaskStatusEnum.class, status));
    }
}

