/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.map.api;

import com.dji.sdk.cloudapi.map.CreateMapElementRequest;
import com.dji.sdk.cloudapi.map.CreateMapElementResponse;
import com.dji.sdk.cloudapi.map.GetMapElementsResponse;
import com.dji.sdk.cloudapi.map.UpdateMapElementRequest;
import com.dji.sdk.common.HttpResultResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="map interface")
public interface IHttpMapService {
    public static final String PREFIX = "map/api/v1";

    @Operation(summary="get map elements", description="In the first connection, pilot will send out this http request to get the group element list. Also, if pilot receives a group refresh instruction from WebSocket, it needs the same interface to request the group element list.", parameters={@Parameter(name="workspace_id", description="workspace id", schema=@Schema(format="uuid")), @Parameter(name="group_id", description="element group id. The same element group can contain multiple map elements, which is equivalent to grouping map elements. When initiating the request, if the group id parameter is not included, the server needs to return all map elements. If the group id is specified, it only needs to return the set of elements in the specified element group", schema=@Schema(format="uuid")), @Parameter(name="is_distributed", description="Whether the element group is distributed.")})
    @GetMapping(value={"map/api/v1/workspaces/{workspace_id}/element-groups"})
    public HttpResultResponse<List<GetMapElementsResponse>> getMapElements(@PathVariable(name="workspace_id") String var1, @RequestParam(name="group_id", required=false) String var2, @RequestParam(name="is_distributed", required=false) Boolean var3, HttpServletRequest var4, HttpServletResponse var5);

    @Operation(summary="create map element", description="When user draws a point, line or polygon on the PILOT/Web side.", parameters={@Parameter(name="workspace_id", description="workspace id", schema=@Schema(format="uuid")), @Parameter(name="group_id", description="element group id. The same element group can contain multiple map elements, which is equivalent to grouping map elements. When initiating the request, if the group id parameter is not included, the server needs to return all map elements. If the group id is specified, it only needs to return the set of elements in the specified element group", schema=@Schema(format="uuid"))})
    @PostMapping(value={"map/api/v1/workspaces/{workspace_id}/element-groups/{group_id}/elements"})
    public HttpResultResponse<CreateMapElementResponse> createMapElement(@PathVariable(name="workspace_id") String var1, @PathVariable(name="group_id") String var2, @Valid @RequestBody CreateMapElementRequest var3, HttpServletRequest var4, HttpServletResponse var5);

    @Operation(summary="update map element", description="When user edits a point, line or polygon on the PILOT/Web side.", parameters={@Parameter(name="workspace_id", description="workspace id", schema=@Schema(format="uuid")), @Parameter(name="element_id", description="element id", schema=@Schema(format="uuid"))})
    @PutMapping(value={"map/api/v1/workspaces/{workspace_id}/elements/{element_id}"})
    public HttpResultResponse updateMapElement(@PathVariable(name="workspace_id") String var1, @PathVariable(name="element_id") String var2, @Valid @RequestBody UpdateMapElementRequest var3, HttpServletRequest var4, HttpServletResponse var5);

    @Operation(summary="delete map element", description="When user delete a point, line or polygon on the PILOT/Web side.", parameters={@Parameter(name="workspace_id", description="workspace id", schema=@Schema(format="uuid")), @Parameter(name="element_id", description="element id", schema=@Schema(format="uuid"))})
    @DeleteMapping(value={"map/api/v1/workspaces/{workspace_id}/elements/{element_id}"})
    public HttpResultResponse deleteMapElement(@PathVariable(name="workspace_id") String var1, @PathVariable(name="element_id") String var2, HttpServletRequest var3, HttpServletResponse var4);
}

