/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.log;

import com.dji.sdk.cloudapi.log.FileUploadStartParam;
import com.dji.sdk.cloudapi.storage.CredentialsToken;
import com.dji.sdk.cloudapi.storage.OssTypeEnum;
import com.dji.sdk.cloudapi.storage.StsCredentialsResponse;
import com.dji.sdk.common.BaseModel;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class FileUploadStartRequest
extends BaseModel {
    @NotNull
    private String bucket;
    @NotNull
    @Valid
    private CredentialsToken credentials;
    @NotNull
    private String endpoint;
    @NotNull
    private String fileStoreDir;
    @NotNull
    private OssTypeEnum provider;
    @NotNull
    private String fileType = "text_log";
    @NotNull
    @Valid
    private FileUploadStartParam params;
    @NotNull
    private String region;

    public FileUploadStartRequest(StsCredentialsResponse sts) {
        this.bucket = sts.getBucket();
        long expire = sts.getCredentials().getExpire();
        sts.getCredentials().setExpire(System.currentTimeMillis() + (expire - 60L) * 1000L);
        this.credentials = sts.getCredentials();
        this.endpoint = sts.getEndpoint();
        this.fileStoreDir = sts.getObjectKeyPrefix();
        this.provider = sts.getProvider();
        this.region = sts.getRegion();
    }

    public FileUploadStartRequest() {
    }

    public String toString() {
        return "FileUploadStartRequest{bucket='" + this.bucket + "', credentials=" + this.credentials + ", endpoint='" + this.endpoint + "', fileStoreDir='" + this.fileStoreDir + "', provider=" + this.provider + ", fileType='" + this.fileType + "', params=" + this.params + ", region='" + this.region + "'}";
    }

    public String getBucket() {
        return this.bucket;
    }

    public FileUploadStartRequest setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public CredentialsToken getCredentials() {
        return this.credentials;
    }

    public FileUploadStartRequest setCredentials(CredentialsToken credentials) {
        this.credentials = credentials;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public FileUploadStartRequest setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getFileStoreDir() {
        return this.fileStoreDir;
    }

    public FileUploadStartRequest setFileStoreDir(String fileStoreDir) {
        this.fileStoreDir = fileStoreDir;
        return this;
    }

    public OssTypeEnum getProvider() {
        return this.provider;
    }

    public FileUploadStartRequest setProvider(OssTypeEnum provider) {
        this.provider = provider;
        return this;
    }

    public String getFileType() {
        return this.fileType;
    }

    public FileUploadStartParam getParams() {
        return this.params;
    }

    public FileUploadStartRequest setParams(FileUploadStartParam params) {
        this.params = params;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public FileUploadStartRequest setRegion(String region) {
        this.region = region;
        return this;
    }
}

