/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.livestream;

import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum VideoTypeEnum {
    ZOOM("zoom"),
    WIDE("wide"),
    THERMAL("thermal"),
    NORMAL("normal"),
    Unknown(""),
    IR("ir");

    private final String type;

    private VideoTypeEnum(String type) {
        this.type = type;
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    @JsonCreator
    public static VideoTypeEnum find(String videoType) {
        return Arrays.stream(VideoTypeEnum.values()).filter(typeEnum -> typeEnum.type.equals(videoType)).findAny().orElseThrow(() -> new CloudSDKException(VideoTypeEnum.class, videoType));
    }
}

