/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.debug;

import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum RemoteDebugStatusEnum {
    SENT("sent", false),
    IN_PROGRESS("in_progress", false),
    OK("ok", true),
    PAUSED("paused", false),
    REJECTED("rejected", true),
    FAILED("failed", true),
    CANCELED("canceled", true),
    TIMEOUT("timeout", true);

    private final String status;
    private final boolean end;

    private RemoteDebugStatusEnum(String status, boolean end) {
        this.status = status;
        this.end = end;
    }

    @JsonValue
    public String getStatus() {
        return this.status;
    }

    public boolean isEnd() {
        return this.end;
    }

    @JsonCreator
    public static RemoteDebugStatusEnum find(String status) {
        return Arrays.stream(RemoteDebugStatusEnum.values()).filter(statusEnum -> statusEnum.status.equals(status)).findAny().orElseThrow(() -> new CloudSDKException(RemoteDebugStatusEnum.class, status));
    }
}

