/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.control;

import com.dji.sdk.annotations.CloudSDKVersion;
import com.dji.sdk.cloudapi.control.CommanderFlightModeEnum;
import com.dji.sdk.cloudapi.control.CommanderModeLostActionEnum;
import com.dji.sdk.cloudapi.device.ExitWaylineWhenRcLostEnum;
import com.dji.sdk.cloudapi.device.RcLostActionEnum;
import com.dji.sdk.cloudapi.wayline.RthModeEnum;
import com.dji.sdk.cloudapi.wayline.SimulateMission;
import com.dji.sdk.common.BaseModel;
import com.dji.sdk.config.version.CloudSDKVersionEnum;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class TakeoffToPointRequest
extends BaseModel {
    @Pattern(regexp="^[^<>:\"/|?*._\\\\]+$")
    @NotNull
    private @Pattern(regexp="^[^<>:\"/|?*._\\\\]+$") @NotNull String flightId;
    @Min(value=-180L)
    @Max(value=180L)
    @NotNull
    private @Min(value=-180L) @Max(value=180L) @NotNull Float targetLongitude;
    @Min(value=-90L)
    @Max(value=90L)
    @NotNull
    private @Min(value=-90L) @Max(value=90L) @NotNull Float targetLatitude;
    @Min(value=2L)
    @Max(value=10000L)
    @NotNull
    private @Min(value=2L) @Max(value=10000L) @NotNull Float targetHeight;
    @Min(value=20L)
    @Max(value=1500L)
    @NotNull
    private @Min(value=20L) @Max(value=1500L) @NotNull Float securityTakeoffHeight;
    @Min(value=2L)
    @Max(value=1500L)
    @NotNull
    private @Min(value=2L) @Max(value=1500L) @NotNull Float rthAltitude;
    @NotNull
    private RcLostActionEnum rcLostAction;
    @NotNull
    @CloudSDKVersion(deprecated=CloudSDKVersionEnum.V1_0_0)
    private ExitWaylineWhenRcLostEnum exitWaylineWhenRcLost;
    @Min(value=1L)
    @Max(value=15L)
    @NotNull
    private @Min(value=1L) @Max(value=15L) @NotNull Integer maxSpeed;
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0)
    @NotNull
    private RthModeEnum rthMode;
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0)
    @NotNull
    private CommanderModeLostActionEnum commanderModeLostAction;
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0)
    @NotNull
    private CommanderFlightModeEnum commanderFlightMode;
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0)
    @NotNull
    @Min(value=2L)
    @Max(value=3000L)
    private @NotNull @Min(value=2L) @Max(value=3000L) Float commanderFlightHeight;
    @Valid
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0)
    private SimulateMission simulateMission;
    private Boolean flightSafetyAdvanceCheck;

    public String toString() {
        return "TakeoffToPointRequest{flightId='" + this.flightId + "', targetLongitude=" + this.targetLongitude + ", targetLatitude=" + this.targetLatitude + ", targetHeight=" + this.targetHeight + ", securityTakeoffHeight=" + this.securityTakeoffHeight + ", rthAltitude=" + this.rthAltitude + ", rcLostAction=" + this.rcLostAction + ", exitWaylineWhenRcLost=" + this.exitWaylineWhenRcLost + ", maxSpeed=" + this.maxSpeed + ", rthMode=" + this.rthMode + ", commanderModeLostAction=" + this.commanderModeLostAction + ", commanderFlightMode=" + this.commanderFlightMode + ", commanderFlightHeight=" + this.commanderFlightHeight + ", simulateMission=" + this.simulateMission + "}";
    }

    public String getFlightId() {
        return this.flightId;
    }

    public TakeoffToPointRequest setFlightId(String flightId) {
        this.flightId = flightId;
        return this;
    }

    public Float getTargetLongitude() {
        return this.targetLongitude;
    }

    public TakeoffToPointRequest setTargetLongitude(Float targetLongitude) {
        this.targetLongitude = targetLongitude;
        return this;
    }

    public Float getTargetLatitude() {
        return this.targetLatitude;
    }

    public TakeoffToPointRequest setTargetLatitude(Float targetLatitude) {
        this.targetLatitude = targetLatitude;
        return this;
    }

    public Float getTargetHeight() {
        return this.targetHeight;
    }

    public TakeoffToPointRequest setTargetHeight(Float targetHeight) {
        this.targetHeight = targetHeight;
        return this;
    }

    public Float getSecurityTakeoffHeight() {
        return this.securityTakeoffHeight;
    }

    public TakeoffToPointRequest setSecurityTakeoffHeight(Float securityTakeoffHeight) {
        this.securityTakeoffHeight = securityTakeoffHeight;
        return this;
    }

    public Float getRthAltitude() {
        return this.rthAltitude;
    }

    public TakeoffToPointRequest setRthAltitude(Float rthAltitude) {
        this.rthAltitude = rthAltitude;
        return this;
    }

    public RcLostActionEnum getRcLostAction() {
        return this.rcLostAction;
    }

    public TakeoffToPointRequest setRcLostAction(RcLostActionEnum rcLostAction) {
        this.rcLostAction = rcLostAction;
        return this;
    }

    public ExitWaylineWhenRcLostEnum getExitWaylineWhenRcLost() {
        return this.exitWaylineWhenRcLost;
    }

    public TakeoffToPointRequest setExitWaylineWhenRcLost(ExitWaylineWhenRcLostEnum exitWaylineWhenRcLost) {
        this.exitWaylineWhenRcLost = exitWaylineWhenRcLost;
        return this;
    }

    public Integer getMaxSpeed() {
        return this.maxSpeed;
    }

    public RthModeEnum getRthMode() {
        return this.rthMode;
    }

    public TakeoffToPointRequest setRthMode(RthModeEnum rthMode) {
        this.rthMode = rthMode;
        return this;
    }

    public CommanderModeLostActionEnum getCommanderModeLostAction() {
        return this.commanderModeLostAction;
    }

    public TakeoffToPointRequest setCommanderModeLostAction(CommanderModeLostActionEnum commanderModeLostAction) {
        this.commanderModeLostAction = commanderModeLostAction;
        return this;
    }

    public CommanderFlightModeEnum getCommanderFlightMode() {
        return this.commanderFlightMode;
    }

    public TakeoffToPointRequest setCommanderFlightMode(CommanderFlightModeEnum commanderFlightMode) {
        this.commanderFlightMode = commanderFlightMode;
        return this;
    }

    public Float getCommanderFlightHeight() {
        return this.commanderFlightHeight;
    }

    public TakeoffToPointRequest setCommanderFlightHeight(Float commanderFlightHeight) {
        this.commanderFlightHeight = commanderFlightHeight;
        return this;
    }

    public TakeoffToPointRequest setMaxSpeed(Integer maxSpeed) {
        this.maxSpeed = maxSpeed;
        return this;
    }

    public SimulateMission getSimulateMission() {
        return this.simulateMission;
    }

    public TakeoffToPointRequest setSimulateMission(SimulateMission simulateMission) {
        this.simulateMission = simulateMission;
        return this;
    }

    public Boolean getFlightSafetyAdvanceCheck() {
        return this.flightSafetyAdvanceCheck;
    }

    public void setFlightSafetyAdvanceCheck(Boolean flightSafetyAdvanceCheck) {
        this.flightSafetyAdvanceCheck = flightSafetyAdvanceCheck;
    }
}

