/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.zoo.cv.wordrecognition;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class PpWordRecognitionTranslator
implements NoBatchifyTranslator<Image, String> {
    private List<String> table;

    public void prepare(TranslatorContext ctx) throws IOException {
        try (InputStream is = ctx.getModel().getArtifact("ppocr_keys_v1.txt").openStream();){
            this.table = Utils.readLines((InputStream)is, (boolean)true);
            this.table.add(0, "blank");
            this.table.add("");
        }
    }

    public String processOutput(TranslatorContext ctx, NDList list) {
        StringBuilder sb = new StringBuilder();
        NDArray tokens = list.singletonOrThrow();
        long[] indices = tokens.get(new long[]{0L}).argMax(1).toLongArray();
        int lastIdx = 0;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] <= 0L || i > 0 && indices[i] == (long)lastIdx) continue;
            sb.append(this.table.get((int)indices[i]));
        }
        return sb.toString();
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray img = input.toNDArray(ctx.getNDManager());
        int[] hw = this.resize32(input.getWidth());
        img = NDImageUtils.resize((NDArray)img, (int)hw[1], (int)hw[0]);
        img = NDImageUtils.toTensor((NDArray)img).sub((Number)Float.valueOf(0.5f)).div((Number)Float.valueOf(0.5f));
        img = img.expandDims(0);
        return new NDList(new NDArray[]{img});
    }

    private int[] resize32(double w) {
        int width = (int)Math.max(32.0, w) / 32 * 32;
        return new int[]{32, width};
    }
}

